using Nemerle.IO;
using System;
using System.Diagnostics;

module BinarySearch {
  mutable program : string;

  Init (args : array [string]) : int * int {
    when (args.Length < 3)
      throw Exception ("too few parameters");

    program = args [0];
    (int.Parse (args [1]), int.Parse (args [2]))
  }

  Execute (val : int) : bool {
    def proc = Process ();
    proc.StartInfo.FileName = program;
    proc.StartInfo.Arguments = val.ToString ();
    _ = proc.Start ();
    proc.WaitForExit ();
    proc.ExitCode == 0
  }
  
  Binary (low : int, up : int) : int * int {
    if (low >= up - 1)
      (low, up)
    else {
      def half = (low + up) / 2;
      if (Execute (half))
        Binary (half, up)
      else
        Binary (low, half);
    }
  }
  
  Main (args : array [string]) : void {
    try {
      def (low, up) = Init (args);
      def (good, fail) = Binary (low, up);
      printf ("The error appeared between %d and %d\n", good, fail)
    }
    catch {
      | e : Exception =>
        printf ("Usage: bsearch script_to_execute low_bound up_bound\n");
        printf ("error: %s\n", e.Message);
    }
  }
}
