/* * 
 *  $Id: video_driver.h 92 2004-03-23 18:17:56Z shawill $
 *  
 *  This file is part of NeMeSI
 *
 *  NeMeSI -- NEtwork MEdia Streamer I
 *
 *  Copyright (C) 2001 by
 *  	
 *  	Giampaolo "mancho" Mancini - manchoz@inwind.it
 *	Francesco "shawill" Varano - shawill@infinto.it
 *
 *  NeMeSI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NeMeSI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NeMeSI; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 *  This file is largely and freely inspired by video_out_internal.h from MPlayer project.
 *  
 * */
 
#ifndef __VIDEO_DRIVER_H
#define __VIDEO_DRIVER_H

#include <nemesi/types.h>
#include <nemesi/video_img.h>

static uint32 preinit(const char *arg, uint32 buff_ms);
static uint32 config(uint32 width, uint32 height, uint32 d_width,
		     uint32 d_height, uint32 fps, uint8 fullscreen,
		     char *title, uint32 format);
/*
static void *config(uint32 width, uint32 height, char *title, uint32 format);
*/
static uint32 control(uint32 cmd, void *arg, ...);
static uint32 get_picture(int w, int h, NMSPicture *pict);
static uint32 draw_picture(NMSPicture *pict, double pts);
static uint32 update_screen(double *next_pts);
static void reset(void);
static void uninit(void);

#define NMS_LIB_VIDEO(x) NMSVFunctions nms_video_##x =\
{\
	&info, \
	preinit, \
	config, \
	control, \
	get_picture, \
	draw_picture, \
	update_screen, \
	reset, \
	uninit \
}

#endif // __VIDEO_DRIVER_H

