/*
   This file is part of the Nepomuk KDE project.
   Copyright (C) 2011 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) version 3, or any
   later version accepted by the membership of KDE e.V. (or its
   successor approved by the membership of KDE e.V.), which shall
   act as a proxy defined in Section 6 of version 3 of the license.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library.  If not, see <http://www.gnu.org/licenses/>.

   The basis for this file was generated by qdbusxml2cpp version 0.7
   Command line was: qdbusxml2cpp -a datamanagementadaptor -c DataManagementAdaptor -m org.kde.nepomuk.DataManagement.xml

   qdbusxml2cpp is Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 */

#ifndef _DATAMANAGEMENTADAPTOR_H_
#define _DATAMANAGEMENTADAPTOR_H_

#include <QtCore/QObject>
#include <QtCore/QHash>
#include <QtCore/QRegExp>
#include <QtDBus/QDBusContext>
#include <QtDBus/QDBusVariant>

#include "simpleresource.h"

class QThreadPool;

namespace Nepomuk2 {
class DataManagementModel;
class DataManagementCommand;

/*
 * Adaptor class for interface org.kde.nepomuk.DataManagement
 */
class DataManagementAdaptor: public QObject, protected QDBusContext
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.nepomuk.DataManagement")

public:
    DataManagementAdaptor(Nepomuk2::DataManagementModel* parent);
    ~DataManagementAdaptor();

    /**
     * Set the prefixes that will be supported for script convenience. The provided hash
     * maps prefixes to namespaces. Typical prefixes include "nao" or "rdfs".
     */
    void setPrefixes(const QHash<QString, QString>& prefixes);

    /**
     * Tries to decode a URI including namespace abbreviation lookup for known ontologies (Example: nao:Tag).
     */
    QUrl decodeUri(const QString& s, bool namespaceAbbrExpansion = true) const;

    /**
     * Tries to decode a list of URIs including namespace abbreviation lookup for known ontologies (Example: nao:Tag).
     */
    QList<QUrl> decodeUris(const QStringList& s, bool namespaceAbbrExpansion = true) const;

public Q_SLOTS:
    Q_SCRIPTABLE void setProperty(const QStringList &resources, const QString &property, const QVariantList &values, const QString &app);
    Q_SCRIPTABLE void addProperty(const QStringList &resources, const QString &property, const QVariantList &values, const QString &app);
    Q_SCRIPTABLE void removeProperty(const QStringList &resources, const QString &property, const QVariantList &values, const QString &app);
    Q_SCRIPTABLE void removeProperties(const QStringList &resources, const QStringList &properties, const QString &app);
    Q_SCRIPTABLE QString createResource(const QStringList &types, const QString &label, const QString &description, const QString &app);
    Q_SCRIPTABLE void removeResources(const QStringList &resources, int flags, const QString &app);
    Q_SCRIPTABLE QList<Nepomuk2::SimpleResource> describeResources(const QStringList &resources, int flags, const QStringList& targetParties);
    Q_SCRIPTABLE QHash<QString, QString> storeResources(const QList<Nepomuk2::SimpleResource>& resources, int identificationMode, int flags, const Nepomuk2::PropertyHash &additionalMetadata, const QString &app);
    Q_SCRIPTABLE void mergeResources(const QString &resource1, const QString &resource2, const QString &app);
    Q_SCRIPTABLE void mergeResources(const QStringList &resources, const QString& app);
    Q_SCRIPTABLE void removeDataByApplication(int flags, const QString &app);
    Q_SCRIPTABLE void removeDataByApplication(const QStringList &resources, int flags, const QString &app);
    Q_SCRIPTABLE void importResources(const QString& url, const QString& serialization, int identificationMode, int flags, const Nepomuk2::PropertyHash &additionalMetadata, const QString& app);
    Q_SCRIPTABLE QString exportResources(const QStringList &resources, const QString& mimeType, int flags, const QStringList& targetParties);

    /// convinience overloads for scripts (no lists)
    Q_SCRIPTABLE void setProperty(const QString &resource, const QString &property, const QDBusVariant &value, const QString &app);
    Q_SCRIPTABLE void addProperty(const QString &resource, const QString &property, const QDBusVariant &value, const QString &app);
    Q_SCRIPTABLE void removeProperty(const QString &resource, const QString &property, const QDBusVariant &value, const QString &app);
    Q_SCRIPTABLE void removeProperties(const QString &resource, const QString &property, const QString &app);
    Q_SCRIPTABLE QString createResource(const QString &type, const QString &label, const QString &description, const QString &app);
    Q_SCRIPTABLE void removeResources(const QString &resource, int flags, const QString &app);
    Q_SCRIPTABLE void importResources(const QString& url, const QString& serialization, int identificationMode, int flags, const QString& app);

private:
    void enqueueCommand(Nepomuk2::DataManagementCommand* cmd);

    Nepomuk2::DataManagementModel* m_model;
    QThreadPool* m_threadPool;
    QHash<QString, QString> m_namespaces;
    QRegExp m_namespacePrefixRx;
};
}

#endif
