#TRUSTED 14691aabb79026ef1edb0e2000c10ae620e485a4a56cbad67f67100e0ae95da375d1c3476882c16b92d59cfcd42c480235ca49af23a214124961021aa56f14054c6f7a725f1f29ee095171631c2a5fd36a7ab006b80cb3f2a4c07bf05138f6a2b55718300db157dfcea838c51328d3d53a683306cc0ef2743f4114eafd966f0cb7ba4fac42e7eba796970bc3baa7ae00a8e813390d1af0f610114cb244ab78b8b7d8361d422e27e69e020f708fcd051cf191c4164dd747968330a793c0dd323fa0cddf1685b19ca5d9015514f5adecb2216334b2e0eb8234e60dc925077c59d6a29d5b5f9ab01a2eb6b726278e5c3f30f3de197aa13ab8d02a64b7292596e916d2e15b27a73aef12d6f397bd0bd27531d3adda4121733eeb52f99fc8c8c943a668e7591a2c3c79dd230fe08fb02a46f09518ffb5cf8fdfcaba7daf44f97a769d475a42b84946e2fb1cd37b8ba417d89882aa9ee14dd903f8582631e458f19d6b7b5fd433b733b63697a1c7089fc8d4b4d922f113abc1b4baa8f64a6e6592ca2c4c5eba8047794271d3d432322e7d5e1834549e85677f1e751c20eab2b9eabcfefdf73899f20c4e487979bcd7de3d8c1e04002f3ea78b52170c3383daaba7e6c8d6909e69382fb2c1634fa337bca9c5a8ca99b226299b49a51f099855a0d359b50904036568d3707600fd96040f28dc02475aa62ec980ec3d505510aae412ce87
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15875);
 script_version ("1.3");
 name["english"] = "Hydra: ICQ";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find ICQ accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force ICQ authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/icq", 5190);
 # Currently, ICQ is not identified by find*.nasl
 script_dependencies("hydra_options.nasl", "find_service2.nasl", "external_svc_ident.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/icq");
if (! port) exit(0); # port = 5190;
if (! get_port_state(port)) exit(0);

# We should check that the server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (!s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "icq";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/icq/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following ICQ accounts:\n' + report);
