#! /usr/bin/perl -w
#
#-----------------------------------------------------------------------------
# $Id: statistic.pl,v 1.12 2008-01-02 13:29:04 anton Exp $
# Contributed to NeTAMS project by A.Rudenko aka RAV (2006/10/21)
#-----------------------------------------------------------------------------

sub html_param_data {
	my ( $st, @v, $unit_str, $policy_str, $year_str, $month_str, $week_str, $day_str );
	my $par		= shift;
	$unit_str 	= $par->{oid};
	$policy_str	= $par->{policy};
	$year_str 	= $par->{year};
	$week_str 	= $par->{week};
	$day_str 	= $par->{day};
	$month_str 	= $par->{month};
	# Global values
	$db   = bdconnect() if ! defined $db;
	%data = %count  = @legend = @unit = @policy = @subplan = ();
	@month_name 	= ('january',	'february',	'march',	'april',
			'may',		'june',	   	'july',		'august',
			'september',	'october',	'november', 	'december');
	@week_name	= ( 'mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
	$step = $all_traff = 0;
	$year = $month  = $week = $day = $oids = $name_tb = $param = "";
	$oids  		= $par->{oids};
	$oids 		= "policy" if ! defined $oids or ( $oids ne "unit" and $oids ne "account" and $oids ne "tree");
	$graph		= $par->{graph}; 	$graph    = "netams_graph.cgi" 	if ! defined $graph;
	$url		= $par->{url};   	$url   	  = "netams_html.cgi"  	if ! defined $url;
	$admintool	= $par->{admintool};	$admintool="./admin/statistic.cgi" if ! defined $admintool;
	$images		= $par->{images};	$images	  ="./images" 		if ! defined $images;
	$detail		= $par->{detail};	$detail	  = 1		 	if ! defined $detail;
	$show_null	= $par->{show_null};	$show_null= 0 			if ! defined $show_null;
	$KiloByte	= $par->{KiloByte};	$KiloByte = 1024		if ! defined $KiloByte or $KiloByte < 1000;
	$desc		= $par->{desc};		$desc	  = ""			if ! defined $desc;

	($year, $month, $week, $day) = set_date( $year_str, $month_str, $week_str, $day_str, $oids );
	if ( $oids eq "tree" )
		{ return html_tree( $unit_str, $policy_str ) }
	$unit_str   = "" if !defined $unit_str;
		if 	( $unit_str ne "" )  { @unit = unic(split( /\,/, $unit_str )); $unit_str = join(",",@unit) }
		elsif ( $oids eq "account" ) { error_html("No Accounts set!!!",$par->{cgi}); return }
		else 			     { error_html("No Units set!!!",   $par->{cgi}); return }
	$policy_str = "" if !defined $policy_str;
		if    ( $policy_str ne "" )	{
			if 	( $oids ne "account" )	{ @policy = unic(split( /\,/, $policy_str )) }
			else				{ @subplan= sort {$a <=> $b} unic(split( /\,/, $policy_str )) } }
		elsif ( $oids ne "account" )	{ @policy = pol_db( @unit );
						  if (scalar( @policy )  == 0) { error_html("No Policys set!!!",$par->{cgi}); return } }
		else				{ @subplan= sort {$a <=> $b} pol_db( @unit ); 
						  if (scalar( @subplan ) == 0) { error_html("No SubPlan set!!!",$par->{cgi}); return } }
		$policy_str = join( ",", @subplan ) if scalar( @subplan )> 0;
		$policy_str = join( ",", @policy )  if scalar( @policy ) > 0;

	$param  = "oid=$unit_str&policy=$policy_str";
	$param .= "&oids=$oids"  if $oids ne "policy";
	$param .= "&detail=0" 	 if !$detail;
	$param .= "&show_null=1" if $show_null;

	if 	( $day eq "" and $week eq "" and $month eq "" ) { $step = 12 }
	elsif	( $day eq "" and $week eq "" ) 			{ $step = last_day( $month, $year ) }
	elsif	( $week ne "" ) 				{ $step = 7 }
	else							{ $step = 24 }

	my ( $name, $k, $where, $wher, @oid);
	@v = ();
	if    ($oids eq "policy") {@oid  = @policy; $name_tb = " Unit <b>" }
	elsif ($oids eq "unit")   {@oid  = @unit;   $name_tb = " Policy <b>"; @unit = @policy }
	elsif ($oids eq "account"){@oid  = @subplan;$name_tb = " Account <b>" }
	for $st (@unit) {
		$name = oid_name( hex($st), ($oids eq "account"?"billing":"oids") );
		next if $name eq "";
		$name_tb .= $name . " (" . $st . ") ";
		push( @v, ($oids eq "account"?$oids:($oids eq "unit"?"policy":"unit")) . "_oid=" . hex($st)) }
	 if ( scalar(@v) == 0 )
		{ error_html("$oids not set!!!",$par->{cgi}); return }
	$wher = " (" . join(" OR ", @v) . ") ";
	$name_tb .= ". $desc </b> Time of creation: " . `date` . ". ";
	for ( $k = 0 ; $k < scalar( @oid ) ; $k++ ) {
		if ( $oids ne "account" ) {
			$name = oid_name( hex $oid[$k] );
			next if $name eq "";
			$where= $oids."_oid=" . hex( $oid[$k] ) . " and " . $wher;
			$name.= " (".$oid[$k].")" }
		else {
			$name = "SubPlan ".$oid[$k];
			$where= "subplan_oid=" . $oid[$k] . " and " . $wher }
		push( @legend, $name );
		db_data( $where, $name, $step, $year, $month, $week, $day, "both", $oids, 1 );
	}
	return html_text( scalar(@legend), $step, $oids );
}

#######################################################
sub html_text {
	my ($k,$step,$oids)=@_;
	my($p1,$p2,$p3,$p4,$i,$j,$in,$out,@isnull,$y,$m,$d);
		$p1 .= "<div style='margin-left: 2%;'>";
		$p1 .= "Statistic for $name_tb <br><br>\n";
		if ($detail) {
			$p1.="<table cellpadding=1 cellspacing=1 border=0>\n";
			$p1.="<tr><td><b>Year:</b></td><td width=50 align=center><A href=$url?$param&year=0> Now </A></td>";
			$p1.="<td><A href=$url?$param&year=".($year-1)."&month=$month&week=$week&day=$day><</A></td>";
			$p1.="<td width=100 align=center><font face=monospace size=+1 color=red> $year </font></td>";
			$p1.="<td><A href=$url?$param&year=".($year+1)."&month=$month&week=$week&day=$day>></A></td>\n";
			if ($oids ne "account")
				{ $p1.="<td width=200 align=center><font size=+1 color=red><A href=$graph?$param&year=$year&month=$month&week=$week&day=$day> Graph </A></font></td>\n" }
			$p1.="<td width=200 align=center><font size=+1 color=red><A href=$admintool?action=form&oids=$oids> Admintool </A></font></td>\n";
			if ($oids ne "account")
				{ $p1.="<td width=200 align=center><font size=+1 color=red><A href=$url?$param&oids=tree&year=$year&month=$month&week=$week&day=$day> UnitsTree </A></font></td>\n" }
			$p1.="</tr><tr><td><b> Month:</b></td><td align=center><A href=$url?$param&year=$year&month=0> Now </A></td>";
			if ($month ne "") {
				$p1.="<td><A href=$url?$param&year=$year&month=".($month>1?$month-1:1)."&day=$day><</A></td>";
				$p1.="<td align=center><font face=monospace size=+1 color=red>";
				$p1.=" $month_name[$month-1] ";
				$p1.="</A>" if $step <= 24;
				$p1.="<td><A href=$url?$param&year=$year&month=".($month>11?12:$month+1)."&day=$day>></A></td>" }
			$p1.="</tr>\n<tr><td><b> Week:</b></td><td align=center><A href=$url?$param&year=$year&week=0> Now </A></td>";
			if ($week ne "") {
				$p1.="<td><A href=$url?$param&year=$year&week=".($week>1?$week-1:1)."><</A></td>";
				$p1.="<td align=center><font face=monospace size=+1 color=red> $week </font></td>";
				$p1.="<td><A href=$url?$param&year=$year&week=".($week>53?54:$week+1).">></A></td>" }
			$p1.="</tr>\n<tr><td><b> Day:</b></td><td align=center><A href=$url?$param&year=&year&month=$month&day=0> Now </A></td>";
			if ($day ne "") {
				$p1.="<td><A href=$url?$param&year=$year&month=$month&day=".($day>1?$day-1:1)."><</A></td>";
				$p1.="<td align=center><font face=monospace size=+1 color=red> $day </font></td>";
				$p1.="<td><A href=$url?$param&year=$year&month=$month&day=".($day==last_day($month,$year)?$day:$day+1).">></A></td>" }
			$p1.="</tr></table>" }
		return $p1."<br><font color=red size=+2>All data for sets is zero :( !!!</font>" if !$show_null and $all_traff == 0;
		$p2.="<table width=95% cellpadding=1 cellspacing=1 border=1>\n";
		$p2.="<tr bgcolor=navy align=center><td rowspan=".($oids eq "account"?3:2)." valign=middle>";
		$p2.="<font face=monospace size=-1 color=yellow>Period/".($oids eq "policy"?"Policy":"Unit")."</font></td>\n";
		for ( $j = 0 ; $j < $k ; $j++ ) {
			if ( !$show_null and $count{"-in ".$legend[$j]} + $count{"-out ".$legend[$j]} == 0) { $isnull[$j]=1; next }
			$isnull[$j]=0;
			$p2.="<td colspan=".($oids eq "account"?4:2)."><font face=monospace color=yellow>$legend[$j]</font></td>\n" }
		$p2.= "</tr><tr bgcolor=black align=center>\n";
		for ( $j = 0 ; $j < $k ; $j++ ) {
			next if $isnull[$j];
			$p2.="<td colspan=".($oids eq "account"?2:1)."><font color=white size=-1> in</font></td>";
			$p2.="<td colspan=".($oids eq "account"?2:1)."><font color=white size=-1> out</font></td>" }
		$p2.="</tr>\n";
		if ( $oids eq "account" ) {
			$p2.= "<tr bgcolor=black align=center>\n";
			for ( $j = 0 ; $j < $k ; $j++ ) {
				next if $isnull[$j];
				$p2.="<td colspan=><font color=white size=-1> traf</font></td>";
				$p2.="<td colspan=><font color=white size=-1> pay</font></td>";
				$p2.="<td colspan=><font color=white size=-1> traf</font></td>";
				$p2.="<td colspan=><font color=white size=-1> pay</font></td>" }
			$p2.="</tr>\n" }
		for ( $i = 0 ; $i < $step ; $i++ ) {
			if ($step == 7) { ($y,$m,$d) = dn_week($year,$week,$i+1) }
			else		{ $y = $year; $m = $month; $d = $day;
				if 	( $step > 24 ) { $d = $i + 1 } 
				elsif 	( $step == 12 ){ $m = $i + 1 } }
			$p3.="<tr align=right><td align=left valign=middle bgcolor=#ffffaa>";
			$p3.="<font color=black>";
			$p3.="<A href=$url?$param&year=$y>" if $detail and $step != 12;
			$p3.=$y;
			$p3.="</A>" if $detail and  $step != 12;
			$p3.="-";
			$p3.="<A href=$url?$param&year=$y&month=$m>" if $detail and  $step <= 24;
			$p3.=$month_name[$m-1];
			$p3.="</A>" if $detail and  $step <= 24;
			if ($step != 12) {
				$p3.="-";
				$p3.="<A href=$url?$param&year=$y&month=$m&day=$d>" if $detail and  $step != 24;
				$p3.=sprintf("%02d",$d);
				$p3.="</A>" if $detail and $step != 24;
				$p3.=" ".$week_name[$i] if $step == 7 }
			$p3.=sprintf("  %02d:00",$i) if $step == 24;
			$p3.="</font></td>\n";
			for ( $j = 0 ; $j < $k ; $j++ ) {
				next if $isnull[$j];
				$in =$data{ '-in '.$legend[$j]}[$i]; $in ="--" if substr($in, 0,2) eq "0 ";
				$p3.="<td><font size=-1> $in</font></td>";
				if ( $oids eq "account" ) {
					$in =b2m($data{ 'pay-in '.$legend[$j]}[$i],"O"); $in ="--" if $in  == 0;
					$p3.="<td><font size=-1> $in</font></td>" }
				$out=$data{'-out '.$legend[$j]}[$i]; $out="--" if substr($out,0,2) eq "0 ";
				$p3.="<td><font size=-1> $out</font></td>\n";
				if ( $oids eq "account" ) {
					$out=b2m($data{'pay-out '.$legend[$j]}[$i],"O"); $out="--" if $out == 0;
					$p3.="<td><font size=-1> $out</font></td>" }
			}
			$p3.="</tr>\n";
		}
		$p4.="<tr bgcolor=black align=right><td valign=middle>";
		$p4.="<font face=monospace size=-1 color=yellow>Sum: </font></td>\n";
		for ( $j = 0 ; $j < $k ; $j++ ) {
			next if $isnull[$j]; $in = $out = 0;
			$p4.="<td><font color=white size=-1>".b2m($count{ "-in ".$legend[$j]},"",1)."</font></td>";
			if ( $oids eq "account" ) {
				$in = b2m($count{ "pay-in ".$legend[$j]},"O");
				$p4.="<td><font color=white size=-1>$in</font></td>" }
			$p4.="<td><font color=white size=-1>".b2m($count{"-out ".$legend[$j]},"",1)."</font></td>\n";
			if ( $oids eq "account" ) {
				$out = b2m($count{"pay-out ".$legend[$j]},"O");
				$p4.="<td><font color=white size=-1>$out</font></td>" }
		}
		$p4.="</tr></table></div>\n";
	return ($p1.$p2.$p3.$p4);
}

#######################################################
sub html_tree {
	my ( $unit_str, $policy_str )=@_;
	my(%unit,@name_oid,$where,$p1,$p2,$p3,$p4,$i,$oid,$in,$out,$param,$r,$name_tb,$name,@v,@o,@g,@topN_max);
	$topN = 5 if !defined $topN;
	$images	="./images" if ! defined $images;
	$name_tb = "<b> Units tree. </b>";
	if ( defined $unit_str and $unit_str ne "" ) 
		{ $unit_str = (split(/,/,$unit_str))[0]; ( $unit_str, @name_oid ) = children( $unit_str ) }
	else	{ $unit_str = "" }
	if ( $unit_str ne "" )
		{ $name_tb .= "Group: ".$tree{OID_NAME}{$unit_str}." (".$unit_str."). " }
	else 	{ $name_tb .= "Root. "; ( $unit_str, @name_oid ) = children( "Root" ) }
	error_html("Not childrens for units tree!!!",1) if scalar(@name_oid)==0;

	if ( defined $policy_str and $policy_str ne "" ) {
		$name_tb .= "Policys: ";
		@v = unic(split( /\,/, $policy_str )); $policy_str = "";
		for ( $i = scalar(@v)-1; $i >= 0; $i-- ) {
			$name = $tree{POLICY_NAME}{$v[$i]};
			if ($name eq "") { splice(@v, $i, 1) }
			else { 	$policy_str.= $v[$i].($i > 0?",":"");
				$name_tb   .= $name."(".$v[$i].")";
				$v[$i]      = hex($v[$i]);
				$name_tb   .= ($i > 0?",":".") } 
		}
		$where = " AND ( policy_oid=" . join( " OR policy_oid=", @v) . " )" } 
	else  { $policy_str = ""; $where = ""; $name_tb .= "All Policys." }
	$name_tb .= " Statistics on ".sprintf("%02d.%02d.%04d.", $day, $month, $year);
	$name_tb .= " Time of creation: " . `date` . ". ";
	$db= bdconnect() if !defined $db;
	$r = $db->prepare( "SELECT unit_oid,sum(bytes_in),sum(bytes_out) FROM summary 
			WHERE prefix=? AND t_from >= unix_timestamp(?) AND 
			t_from <= unix_timestamp(?) $where GROUP BY 1 ORDER BY 2 Desc;" );
	$r->execute( "D", sprintf("%04d-%02d-%02d 00:00:00",$year,$month,$day),
			sprintf("%04d-%02d-%02d 00:00:00",$year,$month,$day) ) or die;
	$i = 0; @v = ();
	while ( ($oid,$in,$out) = $r->fetchrow_array ) {
		next if !defined $name_oid[$oid];
		$unit{$name_oid[$oid]}[1] = $in;
		$unit{$name_oid[$oid]}[2] = $v[$i] = $out;
		$topN_max[11] = $in if $i <= ($topN - 1); $i++;
	}
	if ( $topN > 0 ) {
		@v = sort { $b <=> $a } @v;
		$topN_max[12] = $v[ ($topN) < $i? $topN-1 : $i-1 ] }
	$i = 0; @v = ();
	$r->execute( "D", sprintf("%04d-%02d-%02d 00:00:00",dn_week($year,day2week($year,$month,$day),1)),
			sprintf("%04d-%02d-%02d 00:00:00",$year,$month,$day) ) or die;
	while ( ($oid,$in,$out) = $r->fetchrow_array ) {
		next if !defined $name_oid[$oid];
		$unit{$name_oid[$oid]}[3] = $in;
		$unit{$name_oid[$oid]}[4] = $v[$i] = $out;;
		$topN_max[13] = $in if $i <= ($topN - 1); $i++;
	}
	if ( $topN > 0 ) {
		@v = sort { $b <=> $a } @v;
		$topN_max[14] = $v[ ($topN) < $i? $topN-1 : $i-1 ] }
	$i = 0; @v = ();
	$r->execute( "D", sprintf("%04d-%02d-%02d 00:00:00",$year,$month,1), 
			sprintf("%04d-%02d-%02d 00:00:00",$year,$month,$day) ) or die;
	while ( ($oid,$in,$out) = $r->fetchrow_array ) {
		next if !defined $name_oid[$oid];
		$unit{$name_oid[$oid]}[5] = $unit{$name_oid[$oid]}[7] = $in;
		$unit{$name_oid[$oid]}[6] = $unit{$name_oid[$oid]}[8] = $v[$i] = $out;
		$topN_max[15] = $topN_max[17] = $in if $i <= ($topN - 1); $i++;
	}
	if ( $topN > 0 ) {
		@v = sort { $b <=> $a } @v;
		$topN_max[16] = $topN_max[18] = $v[ ($topN) < $i? $topN-1 : $i-1 ] }
	if ($month > 1) { 
		$i = 0; @v = ();
		$r->execute( "M", $year."-01-01 00:00:00", sprintf("%04d-%02d-01 00:00:00",$year,$month-1) ) or die;
		while ( ($oid,$in,$out) = $r->fetchrow_array ) {
			next if !defined $name_oid[$oid];
			$unit{$name_oid[$oid]}[7] += $in;
			$v[$i] = $unit{$name_oid[$oid]}[8] += $out;
			$topN_max[17] = $in if $i <= ($topN - 1); $i++;
		}
		if ( $topN > 0 ) {
			@v = sort { $b <=> $a } @v;
			$topN_max[18] = $v[ ($topN) < $i? $topN-1 : $i-1 ] }
	}
	$param = "oids=tree";
	$param .= "&detail=0" if !$detail;
	$param .= "&show_null=1" if $show_null;
	$p1 = "<div style='margin-left: 2%;'>";
		$p1 .= "$name_tb <br>\n";
		if ( $detail ) {
			@v = sort keys %{$tree{POLICY_OID}};
			$p1 .= "<br>&nbsp;<b>Policys:</b> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A href=$url?$param&oid=$unit_str&year=$year&month=$month&day=$day> All </A>";
			for $p4 ( @v ) {
				$p2 = $tree{POLICY_OID}{$p4};
				next if !defined $p2 or $p2 eq "" or !defined $p4 or $p4 eq "";
				$p1 .= "&nbsp; | &nbsp;<A href=$url?$param&oid=$unit_str&policy=$p2&year=$year&month=$month&day=$day>$p4</A>";
			}
			$param .= "&policy=$policy_str"	if $policy_str ne "";
			$p1 .= "<br>&nbsp;<b>Tree_Groups:</b>&nbsp;";
			$p1.= "<table cellpadding=1 cellspacing=1 border=0>\n";
			@g = split(/,/,("ROOT_TREE,".$tree{GROUPS}{name}));
			for $str ( @g ) {
				next if ! defined $tree{$str}{childrens}{gname};
				$p1.= "<tr align=right valign=middle><td align=left width=140>";
				if ($str eq "ROOT_TREE") {
					$p1.="&nbsp;ROOT:&nbsp;";
					$p1.= "<A href=$url?$param&year=$year&month=$month&day=$day>";
					$p1.="<img src='$images/showtable-logo.gif' width=15 high=15";
					$p1.=" alt=$tree{ROOT_TREE}{childrens}{name}></A>" }
				else  { $p1.="&nbsp;$str:&nbsp;" }
				$p1.="</td><td>|</td>";
				@v = split(/,/,$tree{$str}{childrens}{gname});
				@o = split(/,/,$tree{$str}{childrens}{goid});
				for ( $i=0; $i<scalar(@v); $i++ ) {
					$p1.= "<td>&nbsp;$v[$i]&nbsp;<A href=$url?$param&oid=$o[$i]&year=$year&month=$month&day=$day>";
					$p1.="<img src='$images/showtable-logo.gif' width=15 high=15";
					$p1.=" alt=$tree{$v[$i]}{childrens}{name}" if defined $tree{$v[$i]}{childrens}{name};
					$p1.= "></A></td>" }
				$p1.="</tr>";
			}	
			$p1.="</table>";
			$param .= "&oid=$unit_str" if $unit_str ne "";
			$p1.="<br><table cellpadding=1 cellspacing=1 border=0>\n";
			$p1.="<tr><td><b>Year:</b></td><td width=50 align=center><A href=$url?$param&year=0&month=$month&day=$day> Now </A></td>";
			$p1.="<td><A href=$url?$param&year=".($year-1)."&month=$month&day=$day><</A></td>";
			$p1.="<td width=100 align=center><font face=monospace size=+1 color=red>";
			$p1.=" $year </font></td>";
			$p1.="<td><A href=$url?$param&year=".($year+1)."&month=$month&day=$day>></A></td>\n";
			$p1.="<td width=200 align=center><font size=+1 color=red><A href=$admintool?action=form> Admintool </A></font></td>\n";
			$p1.="</tr><tr><td><b> Month:</b></td><td align=center><A href=$url?$param&year=$year&month=0&day=$day> Now </A></td>";
			$p1.="<td><A href=$url?$param&year=$year&month=".($month>1?$month-1:1)."&day=$day><</A></td>";
			$p1.="<td align=center><font face=monospace size=+1 color=red>";
			$p1.=" $month_name[$month-1] ";
			$p1.="<td><A href=$url?$param&year=$year&month=".($month>11?12:$month+1)."&day=$day>></A></td>";
			$p1.="</tr>\n<tr><td><b> Day:</b></td><td align=center><A href=$url?$param&year=$year&month=$month&day=0> Now </A></td>";
			$p1.="<td><A href=$url?$param&year=$year&month=$month&day=".($day>1?$day-1:1)."><</A></td>";
			$p1.="<td align=center><font face=monospace size=+1 color=red> $day </font></td>";
			$p1.="<td><A href=$url?$param&year=$year&month=$month&day=".($day==last_day($month,$year)?$day:$day+1).">></A></td>";
			$p1.="</tr></table>";
		}
		$param  = "&year=$year&month=$month&day=$day";
		$param .= "&detail=0" if !$detail;
		$p2 ="<table width=95% cellpadding=1 cellspacing=1 border=1>\n";
		$p2.="<tr bgcolor=navy align=center><td rowspan=2 valign=middle>";
		$p2.="<font face=monospace size=-1 color=yellow> Units </font></td>\n";
		$p2.="<td colspan=2><font face=monospace color=yellow> Day </font></td>\n";
		$p2.="<td colspan=2><font face=monospace color=yellow> Week </font></td>\n";
		$p2.="<td colspan=2><font face=monospace color=yellow> Month </font></td>\n";
		$p2.="<td colspan=2><font face=monospace color=yellow> Year </font></td>\n";
		$p2.= "</tr><tr bgcolor=black align=center>\n";
		$p2.="<td><font color=white size=-1> in</font></td><td><font color=white size=-1> out</font></td>";
		$p2.="<td><font color=white size=-1> in</font></td><td><font color=white size=-1> out</font></td>";
		$p2.="<td><font color=white size=-1> in</font></td><td><font color=white size=-1> out</font></td>";
		$p2.="<td><font color=white size=-1> in</font></td><td><font color=white size=-1> out</font></td>";
		$p2.="</tr>\n"; $p3 = "";
		@name_oid = sort { ( defined $unit{$b}[1]?$unit{$b}[1]:0 ) <=> ( defined $unit{$a}[1]?$unit{$a}[1]:0 ) || 
				   ( defined $unit{$b}[3]?$unit{$b}[3]:0 ) <=> ( defined $unit{$a}[3]?$unit{$a}[3]:0 ) || 
				   ( defined $unit{$b}[5]?$unit{$b}[5]:0 ) <=> ( defined $unit{$a}[5]?$unit{$a}[5]:0 ) || 
				   ( defined $unit{$b}[7]?$unit{$b}[7]:0 ) <=> ( defined $unit{$a}[7]?$unit{$a}[7]:0 ) } keys(%unit);
		if ( $show_null ) {
			if ( $unit_str ne "" ) { $str = $tree{OID_NAME}{$unit_str} } else { $str = "ROOT_TREE" }
			@name_oid = unic( @name_oid, split(/,/,$tree{$str}{childrens}{name}) ) }
		for $name (@name_oid) {
			$p3.="<tr align=right><td align=left valign=middle bgcolor=#ffffaa>";
			$p3.="<font color=black>";
			$p3.="&nbsp;$name (";
			if ( defined $tree{NAME_OID}{$name} ) {
				$p3.= "<A href=$url?$param&oid=$tree{NAME_OID}{$name}>" if $detail;
				$p3.=$tree{NAME_OID}{$name};
				$p3.= "</A>" if $detail }
			$p3.=")</td></font></td>\n";
			for ( $i = 1; $i < 8; $i += 2 ) {
				$p4 = $oid = "black";
				if ( defined $unit{$name}[$i] and $unit{$name}[$i]   > 0 )
					{ $unit{all_traff}[$i] += $in = $unit{$name}[$i];
					 $p4 = "red" if ( defined $topN_max[$i+10] and $in >= $topN_max[$i+10] );
					 $in = b2m( $in, "", 1 ) }
				else 	{ $in = "--" }
				if ( defined $unit{$name}[$i+1] and $unit{$name}[$i+1] > 0 )
					{ $unit{all_traff}[$i+1] += $out = $unit{$name}[$i+1];
					 $oid = "blue" if ( defined $topN_max[$i+11] and $out >= $topN_max[$i+11] );
					 $out = b2m( $out, "", 1 ) }
				else 	{ $out = "--" }
				$p3 .= "<td><font size=-1 color=$p4> $in </font></td>";
				$p3 .= "<td><font size=-1 color=$oid> $out </font></td>";
			}
			$p3.="</tr>\n";
		}
		$p4 ="<tr bgcolor=black align=right><td valign=middle>";
		$p4.="<font face=monospace size=-1 color=yellow>Sum: </font></td>\n";
		for ( $i = 1; $i < 8; $i += 2 ) {
			$in = $out = "0 B"; 
			$in = b2m( $unit{all_traff}[$i],   "", 1 ) if defined $unit{all_traff}[$i];
			$out= b2m( $unit{all_traff}[$i+1], "", 1 ) if defined $unit{all_traff}[$i+1];
			$p4.="<td><font color=white size=-1>$in </font></td>";
			$p4.="<td><font color=white size=-1>$out</font></td>\n" }
		$p4.="</tr></table></div><br>\n";
	return ($p1.$p2.$p3.$p4);
}

#######################################################
sub children {
	my $oid = shift;
	if ( defined $oid ) { $oid = ( split(/,/,$oid) )[0] } else { $oid = "" }
	my ( $str, @v, @oids );
	get_tree() if ! defined %tree;
	if ( $oid ne "Root" and $oid ne "" and defined $tree{OID_NAME}{$oid} ) {
		$str = $tree{OID_NAME}{$oid};
		if ( defined $tree{$str}{childrens}{oid} ) {
			@v = split(/,/,$tree{$str}{childrens}{oid}) }
		elsif ( defined $tree{$str}{parents}{name} ) {
			$oid = ( split(/,/,$tree{$str}{parents}{oid})  )[0];
			$str = ( split(/,/,$tree{$str}{parents}{name}) )[0];
			@v   =   split(/,/,$tree{$str}{childrens}{oid}) if defined $tree{$str}{childrens}{oid} }
		else { $oid  = "Root" } }
	if ( $oid eq "Root" or $oid eq "" or scalar(@v) == 0 )
		{ $oid=""; @v=(); @v = split(/,/,$tree{ROOT_TREE}{childrens}{oid}) }
	for $str (@v) { $oids[hex($str)] = $tree{OID_NAME}{$str} if defined $tree{OID_NAME}{$str} }
	return ( $oid, @oids );
}

#######################################################
sub get_tree {
	my $reload = shift; 
	%tree = (); $reload = 0 if !defined $reload;
	my ( $str, @v, @o, $name, $t_n, $t_o, $t_g, $oid );
	if ( !defined @result_tree or $reload )
		{ @result_tree = split( /\n/, join( "\n", netams_command( "show list | grep OID:", "show policy | grep target:" ) ) ) }
	@o = grep( /^OID:/, @result_tree );
	for $str ( @o ) {
		( $t_n, $oid, $t_o, $name ) = split( /\s+/, $str );
		$tree{OID_NAME}{$oid} = $name;
		$tree{NAME_OID}{$name}= $oid;
		if ( index( $str, " Parents: " ) < 0 ) {
			( $t_n, $oid, $t_o, $name ) = split( /\s+/, $str );
			$t_n = $t_o = "";
			$t_n = $tree{ROOT_TREE}{childrens}{name} if defined $tree{ROOT_TREE}{childrens}{name};
			$t_o = $tree{ROOT_TREE}{childrens}{oid } if defined $tree{ROOT_TREE}{childrens}{oid };
			$t_n .= $name.","; $t_o .= $oid.",";
			$tree{ROOT_TREE}{childrens}{name} = $t_n;
			$tree{ROOT_TREE}{childrens}{oid } = $t_o;
			if ( index( $str, " Type: group " ) > 0 ) {
				$t_n = $t_o = $t_g = "";
				$t_n = $tree{ROOT_TREE}{childrens}{gname} if defined $tree{ROOT_TREE}{childrens}{gname};
				$t_o = $tree{ROOT_TREE}{childrens}{goid } if defined $tree{ROOT_TREE}{childrens}{goid };
				$t_g = $tree{GROUPS}{name} if defined $tree{GROUPS}{name};
				$t_n .= $name.","; $t_o .= $oid.","; $t_g .= $name.",";
				$tree{ROOT_TREE}{childrens}{gname} = $t_n;
				$tree{ROOT_TREE}{childrens}{goid } = $t_o;
				$tree{GROUPS}{name} = $t_g }
		} else {
			( $oid, $name ) = split( / Parents: /, $str );
			$name = ( split( / DS\-list: /, $name ))[0];
			@v = split(/\s+/, $name);
			( $str, $oid, $str, $name, $str, $t_g ) = split( /\s+/, $oid );
			if ( $t_g eq "group" ) {
				$t_g = "";
				$t_g = $tree{GROUPS}{name} if defined $tree{GROUPS}{name};
				$t_g .= $name.",";
				$tree{GROUPS}{name} = $t_g;
				$t_g = "group" }
			while ( $str = shift( @v ) ) {
				$t_n = $t_o = "";
				$t_n = $tree{$str}{childrens}{name} if defined $tree{$str}{childrens}{name};
				$t_o = $tree{$str}{childrens}{oid } if defined $tree{$str}{childrens}{oid };
				$t_n .= $name.","; $t_o .= $oid.",";
				$tree{$str}{childrens}{name} = $t_n;
				$tree{$str}{childrens}{oid } = $t_o;
				if ( $t_g eq "group" ) {
					$t_n = $t_o = "";
					$t_n = $tree{$str}{childrens}{gname} if defined $tree{$str}{childrens}{gname};
					$t_o = $tree{$str}{childrens}{goid } if defined $tree{$str}{childrens}{goid };
					$t_n .= $name.","; $t_o .= $oid.",";
					$tree{$str}{childrens}{gname} = $t_n;
					$tree{$str}{childrens}{goid } = $t_o;
					$t_g = "group" }
				$t_n = $t_o = "";
				$t_n = $tree{$name}{parents}{name} if defined $tree{$name}{parents}{name};
				$t_o = $tree{$name}{parents}{oid } if defined $tree{$name}{parents}{oid };
				$t_n .= $str.( scalar(@v) > 0 ? "," : "");
				$str = ( grep(/ Name:\s+$str\s+/, @result_tree ) )[0];
				$str = ( split( /\s+/, $str ))[1];
				$t_o .= $str.( scalar(@v) > 0 ? "," : "");
				$tree{$name}{parents}{name} = $t_n;
				$tree{$name}{parents}{oid } = $t_o;
	}	}	}
	$tree{GROUPS}{name} = join( ",", sort split(/,/,$tree{GROUPS}{name}));
	@o = grep(/ target: /,@result_tree);
	for $str ( @o ) {
		( $oid, $t_o, $name ) = split( /\s+/, $str );
 		$tree{POLICY_OID}{$name} = $oid;
 		$tree{POLICY_NAME}{$oid} = $name }
}

#######################################################
sub netams_command {
	require "netams_api.pl";
	my @command = @_;
	netams_login($sc_host, $sc_port, $sc_user, $sc_passwd);
	for ( $i = scalar(@command)-1; $i>=0; $i-- ) {
		netams_send( $command[$i] );
		$command[$i] = netams_read() }
	netams_logout();
	return ( @command );
}

#######################################################
sub error_html {
	my ($str,$cg)=@_;
	if ( defined $cg and $cg ) {
		my 	$cgi= new CGI;
		print 	$cgi->header(-type=>'text/html',-expires=>'now', -charset=>'windows-1251') if ! defined $connect_netams;
		print 	"<html><font color=red size=+2>".$str."</font></html>"; exit }
	else { }	#print 	$str."\n"
}

#######################################################
sub pol_db {
	my  @oid = @_;
	my (@unit, $str, $row, $table, $row_w);
	$oids = "policy" if !defined $oids;
	if ($oids ne "account") { $table = "summary"; $row_w = "unit_oid";    $row = "policy_oid" }
	else			{ $table = "bdata";   $row_w = "account_oid"; $row = "subplan_oid" }
	while ( @oid ) {
		$str = shift( @oid );
		next if $str eq "";
		push( @unit, $row_w . "=" . hex( $str ) ) }
	return () if scalar( @unit ) == 0;
	$str 	= join( " OR ", @unit );
	$db  	= bdconnect() if !defined $db;
	my $r  	= $db->prepare("SELECT DISTINCT $row FROM $table WHERE $str;");
	$r->execute or die;
	while ( ( $str )= $r->fetchrow_array ) {
		$str	= sprintf("%6.6X",$str) if $oids ne "account";
		push( @oid, $str ) }
	return @oid;
}

############################################################
sub db_data {									#   summary
	my ($where, $legend, $d, $year, $month, $week, $day, $inout, $kmgt, $v)=@_;
	my ($t_from, $pref, $in, $out, $i, $in_i, $out_i, $acct, @inout, $r);
	$v	= 0 	if ! defined $v     or $v ne "1";
	$inout	="both"	if ! defined $inout or $inout eq "";
	$kmgt 	= "" 	if ! defined $kmgt;
	if ($kmgt eq "account") { $acct = 1; $kmgt = "" }
	else			{ $acct = 0; $kmgt = "" if $kmgt eq "policy" or $kmgt eq "unit" }
	for ($i = 1; $i <= $d; $i++){
		if    ($d  > 24 ) {$pref="D"; $t_from=sprintf("%04d-%02d-%02d 00:00:00",   $year,$month,$i) }
		elsif ($d == 7  ) {$pref="D"; $t_from=sprintf("%04d-%02d-%02d 00:00:00",   dn_week($year,$week,$i)) }
		elsif ($d == 24 ) {$pref="H"; $t_from=sprintf("%04d-%02d-%02d %02d:00:00", $year,$month,$day,$i-1) }
		elsif ($d == 12 ) {$pref="M"; $t_from=sprintf("%04d-%02d-01 00:00:00",     $year,$i) }
		return if $pref eq "";	#   ...
		if ($acct) { $r = $db->prepare( "SELECT sum(bytes_in),sum(bytes_out),sum(pay_in),sum(pay_out) 
				FROM bdata   where prefix='$pref' and t_from = unix_timestamp('$t_from')
				and $where group by account_oid,subplan_oid;" ) }
		else	   { $r = $db->prepare( "SELECT sum(bytes_in),sum(bytes_out) 
				FROM summary where prefix='$pref' and t_from = unix_timestamp('$t_from')
				and $where group by unit_oid,policy_oid;" ) }
		$r->execute or die;
			# $all_traff	global,     
			# %count	global,    
			# %data		global,    
		$count{ "-in ".$legend} += $in_i  = 0 if ( $inout ne "out" );	#    -   0
		$count{"-out ".$legend} += $out_i = 0 if ( $inout ne "in"  );
		while ( (@inout) = $r->fetchrow_array ) {
	    		if ( $inout ne "out") {
				$in				 = $inout[0];
				$in_i 				+= $in;
				$all_traff		  	+= $in;
				$count{"-in ".$legend}	 	+= $in }
	    		if ( $inout ne "in" ) {
				$out				 = $inout[1];
				$out_i	 			+= $out;
				$all_traff			+= $out;
				$count{"-out ".$legend}		+= $out }
			if ( $acct ) {
				$in				 = $inout[2];
				$data{ "pay-in ".$legend}[$i-1] += $in;
				$count{"pay-in ".$legend} 	+= $in;
				$out				 = $inout[3];
				$data{ "pay-out ".$legend}[$i-1]+= $out;
				$count{"pay-out ".$legend}	+= $out }
		}
		$data{ "-in ".$legend}[$i-1] = b2m($in_i, $kmgt, $v) if ( $inout ne "out" );
		$data{"-out ".$legend}[$i-1] = b2m($out_i,$kmgt, $v) if ( $inout ne "in"  );
	}
}

################################################
sub set_date {
	my ($year_str, $month_str, $week_str, $day_str, $oids) = @_;
	my (@v, $year, $month, $week, $day);
	$year = $month = $week = $day = "";
	$oids = "policy" if !defined $oids;

	if ( defined $year_str and $year_str ne "" ) {
		@v = split(/\,/,$year_str );
		for $year_str ( @v ) {
			next if $year_str eq "";
			$year  = $year_str;
			$year += `date +%Y` if $year <= 0;
			$year  = 2001       if $year < 2001;
			last } }
	$year = ( `date +%Y` + 0 ) if $year eq "";
	if ( defined $week_str and $week_str ne "" ) {
		@v = split(/\,/,$week_str );
		for $week_str ( @v ) {
			next if $week_str eq "";
			$week  = $week_str;
			$week  = day2week( split( /-/, substr( $week, 4 ) ) ) if $week =~ "d2w-";
			$week  =~ tr/0-9\-,//cd;
			$week  = 0 if $week > 54;
			$week += `date +%W` + 1 if $week <= 0;
			$week  = 1 if $week <= 0;
			last } }
	day:
	if ( defined $day_str and $day_str ne "" ) {
		$day_str =~ tr/0-9\-,//cd;
		@v = split(/\,/,$day_str );
		for $day_str (@v) {
			next if $day_str eq "";
			$day  = $day_str;
			$day += `date +%d` if $day <= 0;
			$day  = 1 if $day <= 0;
			last } }
	if ( defined $month_str and $month_str ne "" ) {
		$month_str =~ tr/0-9\-,//cd;
		@v = split( /\,/, $month_str );
		for $month_str (@v) {
			next if $month_str eq "";
			$month  = $month_str;
			$month  = 0 if $month > 12;
			$month += `date +%m` if $month <= 0;
			$month  = 1 if $month <= 0;
			last } }
	$month = ( `date +%m` + 0 ) if $day ne "" and $month eq "";	# day set, month not set
	if ( $day eq "" and $oids eq "tree" ) {
		if    ( $week  ne "" )	{ ( $year, $month, $day ) = dn_week( $year, $week, 7 ) }
		elsif ( $month eq "" )	{ $day_str = 0; goto day }
		else			{ $day = last_day( $month, $year ) } }
	return ($year, $month, $week, $day);
}

################################################
sub bdconnect {
	use DBI;
	my  $dbh = DBI->connect("DBI:$sql_type:database=$sql_dbname;host=$sql_host", $sql_login, $sql_password);
	if ($dbh eq "") { die "<A>Error database connecting. </a>"; }
	return $dbh;
}

################################################
sub oid_name {									#  Policy  Unit    SQL
	my ($oid,$table)=@_;
	$table 	= "oids" if !defined $table or $table eq "";
	$db	= bdconnect() if !defined $db;
	my ($name,$r);
	$r 	= $db->prepare("SELECT name from $table where oid=$oid;");
	$r->execute();
	($name)	= $r->fetchrow_array;
	return ( defined $name?$name:"" );
}

################################################
sub unic {
	my @m = @_;
	my ($i, $str, @v);
	for $str ( @m ) {
		next if $str eq "";
		for ($i = scalar(@v)-1; $i >= 0 ;$i--) { last if $str eq $v[$i] }
		push( @v, $str ) if $i < 0 }
	return @v;
}

################################################
sub last_day {
	my ($month, $year) = @_;
	my $days = 0;
	my @days_of_month = (31,28,31,30,31,30,31,31,30,31,30,31);
	$days = $days_of_month[$month-1];
	$days = 29 if ($month == 2) and ($year%4) == 0;
	return( $days );
}

############################################################
sub b2m {										#   K M G T
	my ($val,$t,$v)=@_;
	$val	= 0	if ! defined $val;
	$t 	= ""	if ! defined $t;
	$v 	= 0  	if ! defined $v or $v ne "1";
	$KiloByte= 1024 if ! defined $KiloByte or $KiloByte < 1000;
	my $m = "%d";									#     
	if ($t eq "") {
		$m = "%0.3f ";
		if    ($val>$KiloByte*$KiloByte*$KiloByte*$KiloByte)	{ $t = "T" }
		elsif ($val>$KiloByte*$KiloByte*$KiloByte) 		{ $t = "G" }
		elsif ($val>$KiloByte*$KiloByte) 	    		{ $t = "M" }
		elsif ($val>$KiloByte) 	    				{ $t = "K" }
		else							{ $t = "B"; $m = "%d " }
	}									# +0.5 - rounding off for integers
	if   ($t eq "T") {return sprintf( $m.($v?"T":""), $val/$KiloByte/$KiloByte/$KiloByte/$KiloByte+($m eq "%d"?0.5:0) ) }
	elsif($t eq "G") {return sprintf( $m.($v?"G":""), $val/$KiloByte/$KiloByte/$KiloByte+($m eq "%d"?0.5:0) ) }
	elsif($t eq "M") {return sprintf( $m.($v?"M":""), $val/$KiloByte/$KiloByte+($m eq "%d"?0.5:0) ) }
	elsif($t eq "K") {return sprintf( $m.($v?"K":""), $val/$KiloByte+($m eq "%d"?0.5:0) ) }
	elsif($t eq "B") {return sprintf( $m.($v?"B":""), $val ) }
	elsif($t eq "O") {return sprintf( "%0.3f", $val ) }			# round
}

############################################################
sub dn_week {									#   (YY.MM.DD)      
	my ($y, $w, $dn)=@_;
	$y   = `date +%Y` if ! defined $y  or $y < 2001;
	$w	=	1 if ! defined $w  or ($w += 0) <= 0 or $w > 54;
	$dn	=	1 if ! defined $dn or ($dn+= 0) <= 0;
	my $d	= day1jan($y);
	if ( $w == 1 ) 
		{ if ( $dn >= $d ){ return ($y, 1, $dn-$d+1) } else { return ($y-1, 12, 31-$d+1+$dn) } } 
	else {	my @days_of_month = (31,($y%4)==0?29:28,31,30,31,30,31,31,30,31,30,31);
		$dn = ($w-1) * 7 - $d + 1 + $dn;	# day of year
		$v  = 1;
		while ( $dn > $days_of_month[$v-1] and $v <= 11 ) { $dn -= $days_of_month[$v-1]; $v++ }
		if ( $dn > 31 ) { return ($y+1, 1, $dn-31) } else { return ($y, $v, $dn) } }
}

############################################################
sub day2week {									# return week the set year.month.day
	my ($y, $m, $d) = @_;
	$y   = `date +%Y` if ! defined $y or $y < 2001;
	$m	=	1 if ! defined $m or ($m += 0) <= 0 or $m > 12;
	$d	=	1 if ! defined $d or ($d += 0) <= 0 or $d > 31;
	$d	+= day1jan($y) - 2;
	my @days_of_month = (31,($y%4)==0?29:28,31,30,31,30,31,31,30,31,30,31);
	for ( $y = 0; $y < $m-1; $y++ ) { $d += $days_of_month[$y] }
	return int( $d/7 ) + 1;
}

############################################################
sub day1jan {									# return day of week 01-01 the set year
	my $y	 = shift;
	my $y_2001=1;	# 2001-01-01 - monday (1)
	   $y	-= 2001;
	my $dn	 = $y_2001 + $y + int( $y / 4 );
	   $dn	-= int( $dn / 7 ) * 7 if $dn > 7;
	return $dn;
}

1;

