/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: st_any.h,v 1.67 2009-08-01 09:23:55 anton Exp $ */

//storage types
#define ST_DB_TYPES_NUM       6
extern const char *db_type_name[ST_DB_TYPES_NUM];

enum storage_type { UNKNOWN=0, ST_HASH=1, ST_MYSQL=2, ST_POSTGRES=3, ST_ORACLE=4, ST_RADIUS=5 };

extern const char *st_table_name[ST_CONN_TYPES_NUM];

//////////////////////////////////////////////////////////////////////////
struct sql_config {
	char *hostname;
	char *username;
	char *password;
	char *dbname;
	char *socket;
	u_short port;
};
//////////////////////////////////////////////////////////////////////////
//struct to store SQL methods
struct sql_data {
	u_short  default_port;
	void*    (*stOpenSql)(sql_config *cfg,st_conn_type type);
	void*    (*stCheckSql)(void *fd);
	unsigned (*stSaveSql)(void *fd, char *filename, st_conn_type type);
	void    (*stCloseSql)(void *fd);
	u_char  (*stObtainDbData) (void *fd, char *query,
			void (*FillData)(void*, void* ,char* (*getRowData)(void*, void* , u_char)));
};
//////////////////////////////////////////////////////////////////////////
class Storage {
	public:
		u_char instance;
		storage_type st_type;
		void *FD[ST_CONN_TYPES_NUM]; //connection to database
	
		Storage(storage_type type, u_char id);
		virtual ~Storage();

		//cancel storage
		void Cancel();
		
		//Storage Must have
		virtual void ShowCfg(struct cli_def *cli, u_char flags) {};
		virtual int ProcessCfg(struct cli_def *cli, char **argv, int argc, u_char no_flag) {return CLI_OK;};
		virtual int StoreMSG(Message *msg) {return 0;};
		virtual int Load(st_conn_type type,
			void (*FillData)(void *res, void *row, char* (*getRowData)(void*, void* , u_char))=NULL) {return 0;};

		//tranparent calls
		//virtual void* Open(st_conn_type type);
		virtual int SaveFile(char *filename, st_conn_type type) { return 0;};
		virtual void Close(st_conn_type type) {};
};
//////////////////////////////////////////////////////////////////////////
Storage* InitSqlStorage(storage_type st_type, u_char instance);
Storage* InitHashStorage(storage_type st_type, u_char instance);
Storage* InitRadiusStorage(storage_type st_type, u_char instance);
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
