/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_libpcap.h,v 1.13 2009-08-01 09:23:55 anton Exp $ */

#ifndef NOPCAP

#ifndef __DS_LIBPCAP_H
#define __DS_LIBPCAP_H

#ifdef LINUX
extern "C" {
        #include <pcap.h>
}
#else
#include <pcap.h>
#endif

struct DLT {
        int linktype;
	int offset_link;
	int offset_nl;
        int offset_nl_nosnap;
        const char *descr;
};

// Added by Marat Phattakhoff a.k.a. unReal http://marat.tps.uz/, admin@tps.uz
#ifndef ETHERTYPE_VLAN
#define ETHERTYPE_VLAN 0x8100	/* IEEE 802.1Q VLAN tagging */
#endif
#ifndef ETHERTYPE_IP
#define ETHERTYPE_IP 0x0800	/* IP protocol */
#endif

#ifdef DLT_LINUX_SLL
#define SLL_HDR_LEN 16          /* total header length */
#define SLL_ADDRLEN 8           /* length of address field */
	struct sll_header {
		u_int16_t sll_pkttype;  /* packet type */
		u_int16_t sll_hatype;   /* link-layer address type */
		u_int16_t sll_halen;    /* link-layer address length */
		u_int8_t sll_addr[SLL_ADDRLEN]; /* link-layer address */
		u_int16_t sll_protocol; /* protocol */
	};
#endif

struct captured_data {
	pcap_t *pcap;
	int datalink;
	int offset;
	u_char link_type_idx;
};
#endif

#endif
