/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: netams.h,v 1.270 2009-08-01 09:23:55 anton Exp $ */

#ifndef _NETAMS_H_
#define _NETAMS_H_

#include "config.h"

extern "C" {
	#include "lib.h"
	#include "libcli/libcli.h"
}

#define RUN_PATH 	"/var/netams"

// Includes of local definitions
class Object;
class List;
class Connection;
class Service;
class Service_Html;
class User;
class ConnectionsList;
class ServicesList;
class UsersList;
class Policy;
class PdList;
class NetUnit;
class FIFO;
class PrefixTree;
class Flow;
class Account;
struct policy_data;
struct alert;
struct sLoginData;
struct sQuotaData;
struct BWinfo;
extern const char UNKNOWN_REFERENCE[];
extern const char *buildforstring;
extern char *SHOW_VERSION;

#ifndef MAX_UNITS
#define MAX_UNITS	10000	//number of units*average_numberof_policies_per_unit, increase and rebuild if you have FIFO overflow problems 
#endif

#define CHECK_ACCT	0
#define CHECK_FW	1  

//match flags
typedef u_char match;

#define MATCH_NONE	0
#define MATCH_SRC	1
#define MATCH_DST	2
#define MATCH_BOTH	3

#include "cli.h"
#include "mutex.h"
#include "common.h"
#include "list.h"
#include "connections.h"
#include "security.h"
#include "users.h"
#include "flow.h"
#include "policy_prefix.h"
#include "policy.h"
#include "net_units.h"
#include "messages_fifo.h"
#include "memory.h"
#include "lang.h"

#ifdef HAVE_BILLING
#include "billing.h"
#endif

#define ADD	1
#define REMOVE	0

#define DEBUG_TO_LOG	1
#define DEFAULT_READ_TIMEOUT 1000
#define SCHED_MIN_SLEEP_TIME 999

//default delays for different services
#define PROCESSOR_DELAY 10 //secs
#define PROCESSOR_LIFETIME 300  //secs
#define QUOTACTL_DELAY 55  //secs

#define KILOBYTE 1024LL
#define MEGABYTE (KILOBYTE*KILOBYTE)
#define GIGABYTE (KILOBYTE*KILOBYTE*KILOBYTE)
#define TERABYTE (KILOBYTE*KILOBYTE*KILOBYTE*KILOBYTE)

#define PARSE_OK	1

#define HOST_MASK	0xFFFFFFFF
#define ROUNDUP(a) ((a) > 0 ? (1 + (((a) - 1) | (sizeof(long) - 1))) : sizeof(long))

/////////////////////////////////////////////////////////////////////////////////////////
// Versions Management //////////////////////////////////////////////////////////////////
extern const char aaa_fw_software_name[];
extern const unsigned int aaa_fw_major_version;
extern const unsigned int aaa_fw_minor_version;
extern const unsigned int aaa_fw_subversion;
extern const unsigned int aaa_fw_build_version;
extern const unsigned int aaa_fw_build_version_local;
extern const char aaa_fw_build_time[];
extern const char aaa_fw_build_person[];

//////////////////////////////////////////////////////////////////////////////////////////
extern int flag_log, flag_quiet, flag_nodaemon, flag_syslog;
extern FILE *LOGFILE;
extern char *config_file_name;
extern const char path_to_config[];
extern const char path_to_log[];
extern struct timeval program_start;
extern struct timeval when_config_changed;
extern time_t start_t;

extern ConnectionsList *Connections;
extern ServicesList *Services;
extern UsersList *Users;
extern NetUnitsList *Units;
extern PolicyList *PolicyL;
extern Service *sMain;
extern MessageManager *MsgMgr; 
extern int global_return_code;
extern int is_running;
extern int is_autosave;
extern language lang;

//////////////////////////////////////////////////////////////////////////////////////////
//time calls
time_t netams_time(time_t *t);
int netams_gettimeofday(struct timeval *tv, struct timezone *tzp);
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
#define CFG_NONE				0x00	
#define CFG_NO_PASSWORDS		0x01
#define CFG_SHOW_OIDS			0x02
#define CFG_SHOW_BRIEF			0x04
#define CFG_SHOW_SERVICE_LIST	0x08

#define SHOW_OIDS(cli, flag, name, id)	{ \
	if(flag&CFG_SHOW_OIDS) cli_bufprint(cli, "%06X", id); \
	else if (name && strchr(name, ' ')) \
		cli_bufprint(cli, "\"%s\"", name?name:""); \
	else cli_bufprint(cli, "%s", name?name:""); \
}

#define SHOW_STR(cli, prefix, str) { \
	if (prefix) cli_bufprint(cli, " %s", prefix); \
	if (str && strchr(str, ' ')) \
		cli_bufprint(cli, " \"%s\"", str?str:""); \
	else cli_bufprint(cli, " %s", str?str:""); \
}

//////////////////////////////////////////////////////////////////////////////////////////
// processor service functions
class Service_Processor;
extern Service_Processor *Processor;

enum restrict_type { DROP=1, PASS=0, PASS_LOCAL=2 , BRK=3};

typedef struct AutoAssignEntry {
	in_addr start;
	in_addr stop;
	AutoAssignEntry *next;
	} AutoAssignEntry;

enum au_type_enum { AU_TYPE_HOST=0, AU_TYPE_USER };  
enum au_naming_enum { AU_NAMING_BY_DNS=0, AU_NAMING_PREFIX1=1, AU_NAMING_PREFIX2=2 };
typedef struct AutoUnitsEntry {
	u_char id;
	au_type_enum type;
	au_naming_enum naming;
	char *prefix;
	char *put_to_group;
	AutoUnitsEntry *next;
	} AutoUnitsEntry;

void CreateAutoUnit(oid id, in_addr addr);

enum mac_control_state { MAC_CTL_CHECK=0, MAC_CTL_SKIP=1, MAC_CTL_VIOL=2, MAC_CTL_BACK=3, MAC_CTL_FIXATE=4, MAC_CTL_UPDATE=5  };
typedef struct MacControlEntry {
	oid id;
	in_addr ip;
	struct ether_addr mac;
	mac_control_state state;
	SysPolicy sp;
	} MacControlEntry;
void aMacControl_check(MacControlEntry* table, unsigned num_units, in_addr *ip, struct ether_addr* mac);
void aMacControl_alert(MacControlEntry* t, NetUnit *u, u_char dir);
//////////////////////////////////////////////////////////////////////////////////////////
// html service functionality
enum cpages_type { CPAGES_ALL, CPAGES_GROUPS, CPAGES_NONE, CPAGES_GROUPLIST }; // client pages - unit user&host
enum apages_type { APAGES_ALL, APAGES_NONE }; // accounts pages for billing service

extern Service_Html *Html;
typedef struct Html_grouplist_item {
	oid groupid;
	struct Html_grouplist_item *next;
} Html_grouplist_item;

void sHtmlAction(Service_Html *cfg);
//////////////////////////////////////////////////////////////////////////////////////////
// login service functionality
extern Service *Login;

#define LOGIN_ACTIVE		0x01
#define LOGIN_DEFAULT_ACTIVE	0x02 //currently not used
#define LOGIN_STRICT		0x04
#define LOGIN_UPDATE		0x08

typedef struct sLoginData {
	u_char flags;
	time_t opened; //time when opened
	time_t inact; // unit-specific inactivity timeout
	time_t abs; // unit-specific absolute timeout
	struct in_addr ip_from;
	struct in_addr last_ip_from;
	struct ether_addr mac_from;
	struct ether_addr last_mac_from;
	char *password;
	} sLoginData;

#define S_LOGIN_DEF_default_inact		0
#define S_LOGIN_DEF_default_abs 		0
#define S_LOGIN_DEF_max_inact			12*60*60
#define S_LOGIN_DEF_min_inact			60
#define S_LOGIN_DEF_max_abs				24*12*60*60
#define S_LOGIN_DEF_min_abs				60
#define S_LOGIN_DEF_min_passwd_length	3

//////////////////////////////////////////////////////////////////////////////////////////
void cAccessScriptCall(restrict_type action, NetUnit *u, const char *param=NULL);
//////////////////////////////////////////////////////////////////////////////////////////
// quota control service functionality
extern Service *Quota;

typedef struct qstat {
	unsigned long long in;
	unsigned long long out;
	unsigned long long sum;
	unsigned long long softin;
	unsigned long long softout;
	unsigned long long softsum;
	} qstat;

#define QUOTA_NONE		0
#define QUOTA_ACTIVE		0x01
#define QUOTA_SOFTBLOCKED	0x02
#define QUOTA_BLOCKED		0x04
#define QUOTA_UPDATE		0x08
#define QUOTA_NSS		0x10
#define QUOTA_NHS		0x20
#define QUOTA_NRS		0x40

typedef struct sQuotaData {
	Policy *policy;
	qstat h, d, w, m;
	u_char soft_treshold;
	u_char flags;
	time_t blocked_time;
	oid nso, nho, nro;
	Policy *fw_block_policy; //this policy will be added to this unit's fw list when blocked
	policy_flag fw_block_policy_flags;
	sQuotaData *next;
	} sQuotaData;

#define S_QUOTA_DEF_arraysize 2

#define S_QUOTA_DEF_soft_treshold 80
#define S_QUOTA_DEF_notify_soft 1
#define S_QUOTA_DEF_notify_hard 1
#define S_QUOTA_DEF_notify_return 1

//////////////////////////////////////////////////////////////////////////////////////////
// events functionality
void LogEvent(event_type event, oid uid, oid usid, oid aid, char const *fmt, ...);
//////////////////////////////////////////////////////////////////////////////////////////
// alert
#define MAX_ID_PER_ALERT 10
enum alert_type { MAIL };

typedef struct alert {
	unsigned alert_id;
	oid     report_id;
	oid user_id[MAX_ID_PER_ALERT];
	oid unit_id[MAX_ID_PER_ALERT];
	unsigned unit_id_recursive[MAX_ID_PER_ALERT];
	time_t sent;
	alert_type type;
	char *data;
	time_t expired;
	unsigned tries;
} alert;
//////////////////////////////////////////////////////////////////////////////////////////
//BW interface
typedef struct BWinfo {
	unsigned long in;
	unsigned long out;
} __attribute__((packed)) BWinfo;

BWinfo* setBW(BWinfo* bwi, char **param, u_char *i);
void getBW(BWinfo *bwi, struct cli_def *cli);
//////////////////////////////////////////////////////////////////////////////////////////

#include "services.h"

#endif /* !_NETAMS_H_ */
