/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: netamsctl.c,v 1.28 2009-02-08 20:01:56 anton Exp $ */

#include "config.h"

int main(int argc, char **argv){
int op;
char *rcfile=NULL;
char *buffer;
FILE *RCFILE=NULL;
int i;
char *login=NULL, *password=NULL, *host=NULL, *cmd=NULL;
unsigned short port=20001;
unsigned short is_silent=1;
int mode=0; //0=plain, 1=cli
cmd=(char*)malloc(1024); bzero(cmd, 1023);

while((op=getopt(argc, argv, "vf:")) != EOF){
	switch(op){
		case 'f': rcfile=(char *)malloc(strlen(optarg)+1);
				  strcpy(rcfile, optarg);
				  break;
		case 'v': 	  is_silent=0;
				  break;
		default: break;
		}
	}

for (i=optind; i<argc; i++) {
	strncat(cmd, argv[i], 255);
	strncat(cmd, " ", 5);
	}

if (rcfile) {
	RCFILE=fopen(rcfile, "rt");
	if (!RCFILE) { printf("unable to open specified .rc file, %s\n", rcfile); exit(-1); }
	}
else {
	char *homedir=getenv("HOME");
	if (homedir!=NULL) {
		char *str=(char*)malloc(256);
		sprintf(str, "%s/.netamsctl.rc", homedir);
		RCFILE=fopen(str, "rt");
	}
	if (!RCFILE) RCFILE=fopen(".netamsctl.rc", "rt");
	if (!RCFILE) RCFILE=fopen("/usr/local/etc/.netamsctl.rc", "rt");
	if (!RCFILE) RCFILE=fopen("/etc/.netamsctl.rc", "rt");
	if (!RCFILE) { printf("unable to open .rc file\n"); exit(-1); }
	}

buffer=(char *)malloc(4*1024+1);
while (!feof(RCFILE)){
	fgets(buffer, 4*1024, RCFILE);
	i=strlen(buffer);
	buffer[i-1]=0; //thus we remove \n

	if (!strncasecmp(buffer, "login=", 6)) {
		i-=6;
		login=(char*)malloc(i+1);
		strncpy(login, buffer+6, i-1);
		login[i-1]=0;
		}

	else if (!strncasecmp(buffer, "password=", 9)) {
		i-=9;
		password=(char*)malloc(i+1);
		strncpy(password, buffer+9, i-1);
		password[i-1]=0;
		}

	else if (!strncasecmp(buffer, "host=", 5)) {
		i-=5;
		host=(char*)malloc(i+1);
		strncpy(host, buffer+5, i-1);
		host[i-1]=0;
		}

	else if (!strncasecmp(buffer, "port=", 5)) {
		port=strtol(buffer+5, NULL, 10);
		}

	bzero(buffer, 4*1024);
	}

fclose(RCFILE);

if (!login || !password) { printf ("login or password unspecified\n"); exit(-1); }
if (host==NULL) {
	host=(char*)malloc(i=strlen("localhost")+1);
	strncpy(host, "localhost", i-1);
	}

if (!is_silent) {	// verbose
	printf("host: %s port: %u login: %s password: %s\n", host, port, login, password);
	printf("cmd: %s\n", cmd);
}
if (cmd[0]=='\0') { printf("no command is given\n"); exit(-1); }

int sock;
struct sockaddr_in addr;
struct hostent *hp;

if ((sock=socket(AF_INET,SOCK_STREAM,0))==-1 ) { printf("Connect failed. Possibly NeTAMS is not running?\n"); exit(-1); }

bzero(&addr, sizeof(addr));
addr.sin_family=AF_INET;
hp=gethostbyname(host);
if(!hp) {
	herror("gethostbyname failed ");
	exit(-1);
	}
memcpy((char*)&addr.sin_addr, hp->h_addr_list[0], hp->h_length);
addr.sin_port=htons((unsigned short)(port));

if ((i=connect(sock, (struct sockaddr*)&addr, sizeof(addr)))) { printf("Connect failed. Possibly NeTAMS is not running?\n"); exit(-1); }

FILE *fd;

fd = fdopen(sock, "w+");
setvbuf(fd, NULL, _IONBF, 0);
if (fd==NULL) { printf("fdopen of server socket() failed\n"); exit(-1); }

fgets(buffer, 4*1024, fd);  //printf("got: %s", buffer);
fgets(buffer, 4*1024, fd);  //printf("got: %s", buffer);

bzero(buffer, 1023); fread(buffer, strlen("Username:"), 1, fd);
//printf("got: %s", buffer);

if (strncmp(buffer, "Username:", 9)!=0) {
	//printf("PLAIN version\n");
	fread(buffer, strlen("er login >"), 1, fd);
	//printf("got: %s", buffer);
	fprintf(fd, "%s \n", login);	fflush(fd);
	i=strlen("NeTAMS user password >")+strlen(login);
	bzero(buffer, 1023); fread(buffer, 19, 1, fd);
	//printf("got: %s", buffer);
	if (buffer[18]=='>') { printf("login: failed\n"); shutdown(sock, SHUT_RDWR); close(sock); exit(-1); }
	else { bzero(buffer, 1023); fread(buffer, i-18, 1, fd); }

	fprintf(fd, "%s \n", password); fflush(fd);

	fgets(buffer, 4*1024, fd); // printf("got: %s", buffer);
	fgets(buffer, 4*1024, fd); // printf("got: %s", buffer);
	fgets(buffer, 4*1024, fd); // printf("got: %s", buffer);
	bzero(buffer, 1023); fread(buffer, 1, 1, fd);
	if (buffer[0]!='>') { printf("login: failed\n"); shutdown(sock, SHUT_RDWR); close(sock); exit(-1); }
} else {
	//printf("CLI version\n");
	mode=1;
	fprintf(fd, "%s\r\n", login);	fflush(fd);
	//printf("[1]\n");
	bzero(buffer, 1023); fread(buffer, strlen(login)+3, 1, fd);
	//printf("got[2]: %s\n", buffer);
	bzero(buffer, 1023); fread(buffer, 9, 1, fd);
	//printf("got[3]: %s\n", buffer);
	if (strncmp(buffer, "Password:", 9)!=0) { printf("login: failed\n"); shutdown(sock, SHUT_RDWR); close(sock); exit(-1); }

	fprintf(fd, "%s\r\n", password); fflush(fd);

	fgets(buffer, 4*1024, fd);  //printf("got: %s", buffer);
	fgets(buffer, 4*1024, fd);  //printf("got: %s", buffer);
	bzero(buffer, 1023); fread(buffer, 1, 1, fd);
	if (buffer[0]!='#') { printf("login: failed\n"); shutdown(sock, SHUT_RDWR); close(sock); exit(-1); }
}
//printf("got: %s", buffer);


bzero(buffer, 1023);

char *p=cmd, *pp;
do {
	pp=strstr(p, "&&");
	if (pp) *pp='\0';
	if (mode) { fprintf(fd, "%s\r\n", p); fgets(buffer, 4*1024, fd);  }
	else fprintf(fd, "%s\n", p);
	p=pp+3;

	int prev=10;
	int prev_prev=10;
	while (1) {
		i=fgetc(fd);
		if (feof(fd) || ( (prev=='>' || prev=='#') && i==' ' && ( prev_prev=='\n' || prev_prev==')' ) ) ) break;
		putchar(i);
		prev_prev=prev;
		prev=i;
	}
} while (pp);

shutdown(sock, SHUT_RDWR);
close(sock);

free(buffer);

return 0;
}
/////////////////////////////////////////////////////////////
