/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClassIndex.NameKind;
import org.netbeans.api.java.source.ClassIndex.SearchScope;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.openide.util.Utilities;


/**
 *
 * @author  Chris Webster
 */
public class ServiceLocatorStrategyPanel extends javax.swing.JPanel {

    public static final String IS_VALID = "ServiceLocatorStrategyPanel_isValid"; //NOI18N
    
    private final ClasspathInfo cpInfo;

    /** Creates new form ServiceLocatorStrategyPanel */
    public ServiceLocatorStrategyPanel(String serviceLocatorName, ClasspathInfo cpInfo) {
        initComponents();
        this.cpInfo = cpInfo;
        if (serviceLocatorName != null) {
            unreferencedServiceLocator.doClick();
            className.setText(serviceLocatorName);
        } else {
            noServiceLocator.doClick();
        }
        className.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent documentEvent) {
                validateClass();
            }
            public void insertUpdate(DocumentEvent documentEvent) {
                validateClass();
            }
            public void removeUpdate(DocumentEvent documentEvent) {
                validateClass();
            }
        });
    }
    
    public String classSelected() {
        return (String) 
            (unreferencedServiceLocator.isSelected()?className.getText():null); 
    }

    public JRadioButton getUnreferencedServiceLocator() {
        return unreferencedServiceLocator;
    }
    
    public JTextField getClassName() {
        return className;
    }
    
    private void validateClass() {
        if (unreferencedServiceLocator.isSelected()) {
            if (Utilities.isJavaIdentifier(className.getText())) {
                firePropertyChange(IS_VALID, false, true);
            } else {
                firePropertyChange(IS_VALID, true, false);
            }
        } else {
            firePropertyChange(IS_VALID, false, true);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        noServiceLocator = new javax.swing.JRadioButton();
        unreferencedServiceLocator = new javax.swing.JRadioButton();
        className = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ServiceLocatorStrategy")));
        buttonGroup1.add(noServiceLocator);
        noServiceLocator.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(noServiceLocator, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_NoServiceLocator"));
        noServiceLocator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noLocator(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        add(noServiceLocator, gridBagConstraints);
        noServiceLocator.getAccessibleContext().setAccessibleName("&Generator inline lookup code");
        noServiceLocator.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServiceLocatorStrategyPanel.class, "ACSD_NoServiceLocator"));

        buttonGroup1.add(unreferencedServiceLocator);
        org.openide.awt.Mnemonics.setLocalizedText(unreferencedServiceLocator, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_UseServiceLocatorClass"));
        unreferencedServiceLocator.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                unreferencedServiceLocatorItemStateChanged(evt);
            }
        });
        unreferencedServiceLocator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                existingClassPressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(unreferencedServiceLocator, gridBagConstraints);
        unreferencedServiceLocator.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServiceLocatorStrategyPanel.class, "ACSD_UseServiceLocatorClass"));

        className.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                classNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 5);
        add(className, gridBagConstraints);
        className.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ExistingClassName"));
        className.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ExistingClassName"));

        jButton1.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("MN_Browse").charAt(0));
        jButton1.setText("...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(jButton1, gridBagConstraints);
        jButton1.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_Browse"));
        jButton1.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_Browse"));

    }// </editor-fold>//GEN-END:initComponents

    private void classNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_classNameActionPerformed
        validateClass();
    }//GEN-LAST:event_classNameActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        className.setEnabled(true);
        unreferencedServiceLocator.setSelected(true);
        final ElementHandle<TypeElement> handle = TypeElementFinder.find(cpInfo, new TypeElementFinder.Customizer() {
            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, NameKind nameKind, Set<SearchScope> searchScopes) {                                            
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return true;
            }
        });
        if (handle != null) {
            className.setText(handle.getQualifiedName());
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void unreferencedServiceLocatorItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_unreferencedServiceLocatorItemStateChanged
        validateClass();
    }//GEN-LAST:event_unreferencedServiceLocatorItemStateChanged

    private void noLocator(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noLocator
        disableSelectors();
    }//GEN-LAST:event_noLocator

    private void existingClassPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_existingClassPressed
        disableSelectors();
        className.setEnabled(true);
        validateClass();
    }//GEN-LAST:event_existingClassPressed
    
    private void disableSelectors() {
        className.setEnabled(false);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextField className;
    private javax.swing.JButton jButton1;
    private javax.swing.JRadioButton noServiceLocator;
    private javax.swing.JRadioButton unreferencedServiceLocator;
    // End of variables declaration//GEN-END:variables
    
}
