/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web.tags;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Issue;
import org.netbeans.modules.exceptions.entity.Line;
import org.netbeans.modules.exceptions.entity.Stacktrace;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.modules.exceptions.utils.Utils;

/**
 *
 * @author  Jan Horvath
 * @version
 */

public class IssuezillaHandler extends SimpleTagSupport {
    
    public static final String ISSUEZILLA_DETAIL = "http://www.netbeans.org/issues/show_bug.cgi?id=";
    public static final String ISSUEZILLA_ENTER_BUG = "izredirect?";
//    public static final String EXCEPTION_DETAIL = "http://anna.nbextras.org/exceptions/detail.do?id=";
    
    private String id;
    private Exceptions exceptions;
    
    public void doTag() throws JspException {
        
        JspWriter out=getJspContext().getOut();
        
        try {
            if (exceptions != null) {
                Integer issuezillaId = exceptions.getIssuezillaid();
                Issue issue = null;
                boolean strike = false;
                if (issuezillaId != null) {
                    issue = PersistenceUtils.getInstance().getEntity(Issue.class, issuezillaId);
                }
                String issueStatus = null;
                if (issue != null) {
                    issueStatus = issue.getIssueStatus();
                    if ("RESOLVED".equals(issueStatus) ||                          // NOI18N
                    "VERIFIED".equals(issueStatus) ||                               // NOI18N
                    "CLOSED".equals(issueStatus))  {                                // NOI18N
                        strike = true; 
                    }
                }
                if ((issuezillaId == null) || (issuezillaId.intValue() == 0)) {
                    if (exceptions.getIssuezillaTransfer()) {
                        out.println("in transfer");
                    } else {
                        out.print("<A HREF='");
                        out.print(ISSUEZILLA_ENTER_BUG + "&exceptionsid=" + exceptions.getId());
                        out.println("'>enter</A>");
                    }
                    
                } else {
                    if (strike) {
                        out.println("<STRIKE>");
                    }
                    out.print("<A HREF='");
                    out.print(ISSUEZILLA_DETAIL + issuezillaId);
                    out.println("'>" + exceptions.getIssuezillaid());
                    out.println("</A>");
                    if (strike) {
                        out.println("</STRIKE>");
                    }
                }
            }
            
            JspFragment f=getJspBody();
            if (f != null) f.invoke(out);
            
        } catch (java.io.IOException ex) {
            throw new JspException(ex.getMessage());
        }
        
    }
    
    public void setId(String id) {
        this.id = id;
    }
    
    public void setExceptions(Exceptions exceptions) {
        this.exceptions = exceptions;
    }
    
}
