<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page import="org.netbeans.server.uihandler.statistics.ProjectTypes" %>
<%@ page import="org.netbeans.server.uihandler.TipOfTheDay" %>
<%@ page import="java.util.logging.LogRecord" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.Set" %>
<%@ page import="org.netbeans.modules.exceptions.entity.Issue" %>
<%@ page import="org.netbeans.modules.exceptions.utils.PersistenceUtils" %>
<%@ taglib uri="/WEB-INF/chart-tag.tld" prefix="chart" %>
<%@ taglib uri="/WEB-INF/statistics.tld" prefix="ui" %>

<head>
<jsp:include page="template/header.jsp"/>
<ui:useStatistic name="Exceptions"/>
<ui:useStatistic name="ProjectTypes"/>

<a href="http://www.netbeans.org/index.html">HOME</a> 
/ 
<a href="http://www.netbeans.org/community/index.html">Community</a>
/
<a href="index.jsp">Analytics</a>
/
Upload Logs

</div><td class="valign-top b-right full-width">

<%
    Map<Integer, LogRecord> lastExceptions = (Map<Integer, LogRecord>) pageContext.getAttribute("lastExceptions");
    int issueId = -2;
    boolean duplicate = false;
    int issuezillaId = 0;
    LogRecord log = null;
    if (lastExceptions != null) log = lastExceptions.get(2);
    if (log != null){
        Object[] params = log.getParameters();
        if (params != null){
            if (params[0] instanceof Integer) issueId = (Integer) params[0];
            if (params[1] instanceof Boolean) duplicate = (Boolean) params[1];
            if (params[2] instanceof Integer) issuezillaId = (Integer) params[2];
        }
    }
    boolean fixed = PersistenceUtils.getInstance().issueIsFixed(issuezillaId);
    String targetMilestone = null;
    if (fixed) {
        Issue issue = PersistenceUtils.getInstance().getEntity(Issue.class, new Integer(issuezillaId));
        if (issue != null) {
            targetMilestone = issue.getTargetMilestone();
        }
    }
    if (issueId == -2){
%>    
        <%-- STATISTICS --%>
    <div class="f-page-cell bg-sky" >
        <h2>Upload of NetBeans Analytics Logs Finished</h2>
        
        <p>
            Thank you very much for sending information about your UI gestures
            to our server. Your data form a very important information that will not
            be lost.
        </p>

        <p>
            Please see the graph section on the right to see various comparitions
            between tasks that you performed and those that were done by other users.
        </p>
        
        <% 
        Set last = (Set)pageContext.getAttribute("lastProjectTypes");
        TipOfTheDay.Tip tip = TipOfTheDay.getDefault().find(last);
        if (tip != null) {
            pageContext.setAttribute("tip", tip);
        %>

        <p>
        After analysing your last log file, we are proud to offer you
        following tip of the day. You might be interested in reading about:
        </p>


<div class="b-bottom-dashed b-top f-page-cell">
	<img alt="" src="http://www.netbeans.org/images/v5/wp.png" class="float-left" style="margin-right:10px;"/>
	<h1 class="font-light normal">Tip of the Day</h1>

<table>
<thead>
  <th align="left">${tip.title}</th>
</thead>
<tr>
    <td>
    ${tip.description}
    </td>
</tr>
<tr align="left">
    <td>
        <jsp:element name="a">
            <jsp:attribute name="href">${tip.url}</jsp:attribute>
            <jsp:body>Read more...</jsp:body>
        </jsp:element>
    </td>
</tr>

</table>
</div>
            
        <% } %>

<div class="b-bottom-dashed b-top f-page-cell">
	<img alt="Thank you" src="http://www.netbeans.org/images/v5/kpackage.png" class="float-left" style="margin-right:10px;"/>
	<h1 class="font-light normal">Thank You!</h1>
    <p>
        Once again thank you for helping us with this application. 
        We hope that here in provided information was at least
        a bit interesting. Thank you for your data and do not hesitate to submit 
        another ones next time! We will be always working on better statistics.
    </p>
</div>
    
    
    <% }else{ %> 
    <%-- ERROR REPORT --%>

    <div class="f-page-cell bg-sky" >

        <h2>Upload of NetBeans Error report finished</h2>
        
        <h5>
            Thank you very much for sending error information to our server.
        </h5>
    
    
        <p>
            We have checked the system for your report and it seems to be 
            <% if (!duplicate){ %>
            <%-- NO DUPLICATE --%>
                a new report. It has now been inserted into the database as
                <a href="<%=org.netbeans.server.uihandler.Utils.EXCEPTIONS_URL%>detail.do?id=<%=issueId%>">
                report number <%= issueId %></a>. Your problem is going
                to be evaluated by <a href="http://qa.netbeans.org">NetBeans QE</a>.
                After evaluation it is going be inserted into Issuezilla with suitable
                component and subcomponent. 
                If you have provided your netbeans.org      
                username, you will be informed of updates.                
                

            <% }else{ %>
            <%-- DUPLICATE --%>
                a very similar report to
                <a href="<%=org.netbeans.server.uihandler.Utils.EXCEPTIONS_URL%>detail.do?id=<%=issueId%>">
                    report number <%= issueId %>
                </a>. Your comment and logging information were added to this one. 
                
               <% if (issuezillaId != 0){ 
                   if (fixed) {%>
                        <%-- FIXED --%>
                        <h5>
                            This issue was already fixed.
                        </h5>
                        <p>
                            <% if (targetMilestone != null) { %>
                                Please update your current build of NetBeans to the target milestone <%= targetMilestone %> 
                                where the <a href="http://www.netbeans.org/issues/show_bug.cgi?id=<%= issuezillaId %>">
                                issue #<%= issuezillaId %></a> is fixed.
                            <% } else { %>
                                The <a href="http://www.netbeans.org/issues/show_bug.cgi?id=<%= issuezillaId %>">
                                issue #<%= issuezillaId %></a> is fixed, you can check Issuezilla for more information.
                            <% } %>
                        </p>
                <% } else { %>
                    <p>
                        <%-- NOT FIXED --%>
                        We will use it to find the reason of this problem.
                        This issue was already reported in Issuezilla tracking system you
                        can see the progres directly 
                        <a href="http://www.netbeans.org/issues/show_bug.cgi?id=<%= issuezillaId %>"> here</a>.
                    </p>
                    <% }
            } %>
                 
            <% } %>
        
        <p>
            If you find this issue severe and you have your NetBeans login, you can 
            use the previous link to check all the generated information in our web 
            application and you can enter this issue directly to issuezilla. 
            You can see all reported issues at 
            <a href="<%=org.netbeans.server.uihandler.Utils.EXCEPTIONS_URL%>"> exceptions</a>
            web site.

        </p>
        <p>
            Thank you again for your help.
        </p>

        <% }%>
         <p>
            Your <a href="http://www.netbeans.org">NetBeans</a> development team!
         </p>
     </div>
    
<jsp:include page="template/footer.jsp"/>
