/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.ui;

import java.awt.event.ItemEvent;
import javax.swing.JPanel;
import org.netbeans.modules.scripting.php.dbginterface.api.VariableNode;
import org.netbeans.modules.scripting.php.dbginterface.VariablesModelFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

/**
 *
 * @author  Peter Williams
 */
public class VariablesFilter extends JPanel {
    
    // Temporary to default functions to off and test filtering code.
    private boolean [] filters;
    private boolean initializing;
    
    /** Creates new form VariablesFilter */
    public VariablesFilter(boolean [] currentFilters) {
        filters = currentFilters;
        initializing = false;
        
        initComponents();
        initUserComponents();
        initState();
    }
    
    public boolean [] getFilters() {
        return filters;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        labelFieldsToDisplay = new javax.swing.JLabel();
        checkScriptField = new javax.swing.JCheckBox();
        checkJavaField = new javax.swing.JCheckBox();
        checkUndefinedField = new javax.swing.JCheckBox();
        checkScriptAdapter = new javax.swing.JCheckBox();
        checkFunctions = new javax.swing.JCheckBox();

        labelFieldsToDisplay.setText("Select the fields to show:");

        checkScriptField.setText("Script Field");
        checkScriptField.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkScriptField.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkScriptField.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkScriptFieldItemStateChanged(evt);
            }
        });

        checkJavaField.setText("Java Field");
        checkJavaField.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkJavaField.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkJavaField.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkJavaFieldItemStateChanged(evt);
            }
        });

        checkUndefinedField.setText("Undefined Field");
        checkUndefinedField.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkUndefinedField.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkUndefinedField.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkUndefinedFieldItemStateChanged(evt);
            }
        });

        checkScriptAdapter.setText("Script Adapter");
        checkScriptAdapter.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkScriptAdapter.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkScriptAdapter.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkScriptAdapterItemStateChanged(evt);
            }
        });

        checkFunctions.setText("Functions");
        checkFunctions.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkFunctions.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkFunctions.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkFunctionsItemStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(checkJavaField)
                            .add(checkScriptField)
                            .add(checkUndefinedField)
                            .add(checkScriptAdapter)
                            .add(checkFunctions)))
                    .add(labelFieldsToDisplay))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(labelFieldsToDisplay)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkScriptField)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkJavaField)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkUndefinedField)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkScriptAdapter)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkFunctions)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void checkFunctionsItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkFunctionsItemStateChanged
        setFilter(evt, VariableNode.TYPE_FUNCTION);        
    }//GEN-LAST:event_checkFunctionsItemStateChanged

    private void checkScriptAdapterItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkScriptAdapterItemStateChanged
        setFilter(evt, VariableNode.TYPE_SCRIPT_ADAPTER);        
    }//GEN-LAST:event_checkScriptAdapterItemStateChanged

    private void checkUndefinedFieldItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkUndefinedFieldItemStateChanged
        setFilter(evt, VariableNode.TYPE_UNDEFINED_FIELD);        
    }//GEN-LAST:event_checkUndefinedFieldItemStateChanged

    private void checkJavaFieldItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkJavaFieldItemStateChanged
        setFilter(evt, VariableNode.TYPE_JAVA_FIELD);        
    }//GEN-LAST:event_checkJavaFieldItemStateChanged

    private void checkScriptFieldItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkScriptFieldItemStateChanged
        setFilter(evt, VariableNode.TYPE_SCRIPT_FIELD);
    }//GEN-LAST:event_checkScriptFieldItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox checkFunctions;
    private javax.swing.JCheckBox checkJavaField;
    private javax.swing.JCheckBox checkScriptAdapter;
    private javax.swing.JCheckBox checkScriptField;
    private javax.swing.JCheckBox checkUndefinedField;
    private javax.swing.JLabel labelFieldsToDisplay;
    // End of variables declaration//GEN-END:variables
    
    private void initUserComponents() {
        // set icons to checkboxes -- !PW FIXME need a way to get icons from debugger/core
//        checkFunctions.setIcon(new ImageIcon(Utilities.loadImage("/" + VariableNode.FUNCTION_ICON)));
//        checkJavaField.setIcon(new ImageIcon(Utilities.loadImage("/" + VariableNode.JAVA_FIELD_ICON)));
//        checkScriptAdapter.setIcon(new ImageIcon(Utilities.loadImage("/" + VariableNode.SCRIPT_ADAPTER_ICON)));
//        checkScriptField.setIcon(new ImageIcon(Utilities.loadImage("/" + VariableNode.SCRIPT_FIELD_ICON)));
//        checkUndefinedField.setIcon(new ImageIcon(Utilities.loadImage("/" + VariableNode.UNDEFINED_FIELD_ICON)));
    }
    
    private void initState() {
        try {
            initializing = true;
            checkFunctions.setSelected(filters[VariableNode.TYPE_FUNCTION]);
            checkJavaField.setSelected(filters[VariableNode.TYPE_JAVA_FIELD]);
            checkScriptAdapter.setSelected(filters[VariableNode.TYPE_SCRIPT_ADAPTER]);
            checkScriptField.setSelected(filters[VariableNode.TYPE_SCRIPT_FIELD]);
            checkUndefinedField.setSelected(filters[VariableNode.TYPE_UNDEFINED_FIELD]);
        } finally {
            initializing = false;
        }
    }
    
    private void setFilter(ItemEvent e, int type) {
        if(!initializing) {
            filters[type] = interpretCheckboxState(e);
        }
    }
    
    private boolean interpretCheckboxState(ItemEvent e) {
        boolean state = false;

        if(e.getStateChange() == ItemEvent.SELECTED) {
            state = true;
        } else if(e.getStateChange() == ItemEvent.DESELECTED) {
            state = false;
        }

        return state;
    }    
    
    public static void showDialog() {
        VariablesFilter filterPanel = new VariablesFilter(VariablesModelFilter.getFilterSettings());
        DialogDescriptor desc = new DialogDescriptor(filterPanel, "Local Variable Filters");
        DialogDisplayer.getDefault().createDialog(desc).setVisible(true);
        if (desc.getValue().equals(DialogDescriptor.OK_OPTION)) {
            VariablesModelFilter.setFilters(filterPanel.getFilters());
        }
    }

}
