/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.rt.providers.impl.ftp;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.php.rt.providers.impl.HostImpl;


/**
 * @author ads
 *
 */
public class FtpHostImpl extends HostImpl {

    public static final String CONTEXT_ROOT_PATH = "context-root-path"; // NOI18N
    public static final String FTP_SERVER = "ftp-server"; // NOI18N
    public static final String FTP_USER_NAME = "ftp-user-name"; // NOI18N
    public static final String FTP_PASSWORD = "ftp-password"; // NOI18N
    public static final String FTP_DIRECTORY = "ftp-directory"; // NOI18N

    FtpHostImpl(String domain, String port, FtpServerProvider provider) {
        super(domain, port, provider);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#getProperty(java.lang.String)
     */
    public Object getProperty(String key) {
        Object obj = super.getProperty(key);
        if (obj != null) {
            return obj;
        } else if (CONTEXT_ROOT_PATH.equals(key)) {
            return myContextRootPath;
        } else if (FTP_SERVER.equals(key)) {
            return myFtpServer;
        } else if (FTP_USER_NAME.equals(key)) {
            return myFtpUserName;
        } else if (FTP_PASSWORD.equals(key)) {
            return myFtpPassword;
        } else if (FTP_DIRECTORY.equals(key)) {
            return myFtpDirectory;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#putProperty(java.lang.String, java.lang.Object)
     */
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        if (CONTEXT_ROOT_PATH.equals(key)) {
            assert value instanceof String;
            myContextRootPath = (String) value;
        } else if (FTP_SERVER.equals(key)) {
            assert value instanceof String;
            myFtpServer = (String) value;
        } else if (FTP_USER_NAME.equals(key)) {
            assert value instanceof String;
            myFtpUserName = (String) value;
        } else if (FTP_PASSWORD.equals(key)) {
            assert value instanceof char[];
            myFtpPassword = (char[]) value;
        } else if (FTP_DIRECTORY.equals(key)) {
            assert value instanceof String;
            myFtpDirectory = (String) value;
        }
    }


    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.providers.impl.HostImpl#equals(java.lang.Object)
     */
    /*
    @Override
    public boolean equals( Object obj )
    {
        if ( !( obj instanceof FtpHostImpl ) ){
            return false;
        }
        FtpHostImpl impl = (FtpHostImpl) obj;
        boolean superEq = super.equals(obj);
        if ( !superEq ){
            return false;
        }
        return getFtpServer().equals( impl.getFtpServer() );
    }*/

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    /*
    @Override
    public int hashCode()
    {
        return getDomain().hashCode()*37*37 + getPort().hashCode()*37 + getFtpServer().hashCode();
    }*/
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#getId()
     */
    public String getId() {
        return getName();
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.providers.impl.HostImpl#getDomain()
     */
    @Override
    protected String getDomain() {
        return super.getDomain();
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.providers.impl.HostImpl#getPort()
     */
    @Override
    protected String getPort() {
        return super.getPort();
    }

    protected String getFtpServer() {
        return myFtpServer;
    }

    private String myContextRootPath;

    private String myFtpServer;

    private String myFtpUserName;
    // password is stored as char[] because of security reasons suggested in Java 2 platform v1.2
    private char[] myFtpPassword;

    private String myFtpDirectory;
    
    /**
     * contains FtpHost helper methods
     */
    public static class Helper{
        
    public static String getHttpUrl(FtpHostImpl host) {
        String httpUrlResult = null;
        
        String domain = host.getDomain();
        int port = Integer.parseInt(host.getPort());
        String contextRootPath = (String) host.getProperty(CONTEXT_ROOT_PATH);

        if (!contextRootPath.startsWith("/")) {
            contextRootPath = "/" + contextRootPath;
        }

        URL httpUrl = null;
        try {
            httpUrl = new URL("http", domain, port, contextRootPath);
            httpUrlResult = httpUrl.toString();
        } catch (MalformedURLException ex) {
            httpUrlResult = null;
        }
        return httpUrlResult;
    }

    public static String getFtpUrl(FtpHostImpl host) {
        String ftpUrlResult = null;

        String ftpServer = (String) host.getProperty(FTP_SERVER);
        //String ftpUserName = (String) getProperty(FTP_USER_NAME);
        String ftpDirectory = (String) host.getProperty(FTP_DIRECTORY);

        if (!ftpDirectory.startsWith("/")) {
            ftpDirectory = "/" + ftpDirectory;
        }


        URL ftpUrl = null;
        try {
            ftpUrl = new URL("ftp", ftpServer, ftpDirectory);
            ftpUrlResult = ftpUrl.toString();
        } catch (MalformedURLException ex) {
            ftpUrlResult = null;
        }
        return ftpUrlResult;
    }
        
       /**
        * joins base url with additional subdirectory path.
        * e.g. 
        * <pre>
        * 'http://server/project' with 'subproject'
        * </pre>
        * result is 
        * <pre>
        * 'http://server/project/subproject'
        * </pre>
        */
        public static String addSubdirectoryToUrl(String baseUrl, 
               String subdir) throws MalformedURLException 
        {
            if (subdir == null) {
                return baseUrl;
            }

            String context = subdir;
            if (!context.startsWith("/")) {
                context = "/" + context;
            }

            URL rootUrl = new URL(baseUrl);
            String rootPath = rootUrl.getPath();
            // prevent double slash on rootPath and context connection
            if (rootPath.endsWith("/") && context.startsWith("/")) {
                rootPath = rootPath.substring(0, rootPath.length() - 1);
            }

            URL resultUrl = new URL(rootUrl, rootPath + context);

            return resultUrl.toString();
        }
       
        public static String getFtpUrlWithSubdir(FtpHostImpl host, 
                String subdirectory) throws MalformedURLException 
        {

            return addSubdirectoryToUrl(getFtpUrl(host), subdirectory);
        }
        
       /**
        * returns ftp initial directory specified in host 
        * with added subdirectory path
        */
        public static String getFtpInitialDirWithSubdir(
                FtpHostImpl host, String subdirectory) 
        {
            String rootPath = (String) host.getProperty( FTP_DIRECTORY );
            if (rootPath != null) {

                String contextPath = subdirectory != null ? subdirectory : "";
                if (!contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                }

                if (rootPath.endsWith("/") && contextPath.startsWith("/")) {
                    rootPath = rootPath.substring(0, rootPath.length() - 1);
                }
                if (!rootPath.startsWith("/")) {
                    rootPath = "/" + rootPath;
                }
                return rootPath + contextPath;
            }
            return null;
        }
        
        public static String getHttpUrlWithSubdir(FtpHostImpl host,
               String subdirectory) throws MalformedURLException
        {
            return addSubdirectoryToUrl(getHttpUrl(host), subdirectory);
        }
        
        
    }
}
