/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.core.scenario;

import java.awt.Component;
import java.awt.Container;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;

import org.netbeans.modules.xml.api.scenario.*;

import java.awt.Dialog;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;

/**
 * This panel allows the user to edit scenarios for a particular DataObject.
 *
 * @author  asgeir@dimonsoftware.com
 */
public class ScenarioPanel extends javax.swing.JPanel {
    
    /** The list model which represents the scenarios */
    private DefaultComboBoxModel scenarioModel;
    
    /** The selected scenario, one of the Scenario objects in scenarioModel
     * @supplierCardinality 0..**/
    private Scenario selectedScenario;
    
    /** The svenario that was selected at startup */
    private Scenario selectedScenarioAtStartup;
    
    /** The DataObject which owns the scenarios */
    private DataObject dataObject;
    
    /** Mapping from scenario to a UI component for that scenario */
    private HashMap uiCompMap = new HashMap();
    
    /** Creates new form ScenarioPanel */
    public ScenarioPanel(DataObject dataObject, DefaultComboBoxModel scenarioModel) {
        this.scenarioModel = scenarioModel;
        this.dataObject = dataObject;
        
        initComponents();
        
        scenarioList.setModel(scenarioModel);
        selectedScenarioAtStartup = selectedScenario = (Scenario)scenarioModel.getSelectedItem();
        scenarioList.setSelectedValue(selectedScenario, true);
        
    }
    
     public boolean createScenario() {
        Scenario s = NewScenarioPanel.createScenario(dataObject, scenarioModel);
        if (s != null) {
            scenarioList.setSelectedValue(s, true);
            enableControls();
            m_addedScenarios.add(s);
            return true;
        }
        
        return false;
    }
    
    public void rollBackAddedAndRemovedScenarios() {
        for(int i=0; i<m_deletedScenarios.size(); i++) {
            // put deleted scenarios back in
            Scenario scen = (Scenario)m_deletedScenarios.get(i);
            scenarioModel.addElement(scen);
        }
        m_deletedScenarios.clear();
        for(int i=0; i<m_addedScenarios.size(); i++) {
            // remove added scenarios
            Scenario scen = (Scenario)m_addedScenarios.get(i);
            scenarioModel.removeElement(scen);
        }
        m_addedScenarios.clear();
        scenarioModel.setSelectedItem(selectedScenarioAtStartup);
    }

   /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        scenarioList = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        renameButton = new javax.swing.JButton();
        curScenarioPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(new javax.swing.border.TitledBorder("Scenarios"));
        jPanel1.setMinimumSize(new java.awt.Dimension(172, 100));
        jPanel1.setPreferredSize(new java.awt.Dimension(172, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(100, 70));
        scenarioList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        scenarioList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                scenarioListValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(scenarioList);

        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.GridLayout(2, 0));

        addButton.setText("New");
        addButton.setToolTipText("Create new scenario");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        jPanel2.add(addButton);

        removeButton.setText("Delete");
        removeButton.setToolTipText("Delete selected scenario");
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        jPanel2.add(removeButton);

        renameButton.setText("Rename");
        renameButton.setToolTipText("Rename selected scenario");
        renameButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                renameButtonActionPerformed(evt);
            }
        });

        jPanel2.add(renameButton);

        jPanel1.add(jPanel2, java.awt.BorderLayout.SOUTH);

        add(jPanel1, java.awt.BorderLayout.WEST);

        curScenarioPanel.setLayout(new java.awt.BorderLayout());

        curScenarioPanel.setBorder(new javax.swing.border.TitledBorder("Options"));
        curScenarioPanel.setMinimumSize(new java.awt.Dimension(450, 200));
        curScenarioPanel.setPreferredSize(new java.awt.Dimension(450, 200));
        add(curScenarioPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    private void renameButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_renameButtonActionPerformed
        if (selectedScenario != null) {
            NamePanel namePanel = new NamePanel();
            namePanel.setName(selectedScenario.getName());
            
            DialogDescriptor dialogDecr = new DialogDescriptor(namePanel, "Enter new name");
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDecr);
            dialog.show();
            
            if (dialogDecr.getValue() == DialogDescriptor.OK_OPTION) {
                selectedScenario.setName(namePanel.getName());
                scenarioList.revalidate();
                scenarioList.repaint();
            }
            
        }
    }//GEN-LAST:event_renameButtonActionPerformed
    
    private void scenarioListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_scenarioListValueChanged
        if (!evt.getValueIsAdjusting()) {
            // this event is called twice each time a new item is selected, both when the mouse is
            // pressed and when it is released, with this check the new panel is only created when
            // the button is released (the other way around won't work, because then the panel wont show
            // up at dialog startup) - Swing bug?
            curScenarioPanel.removeAll();
            
            Scenario scenario = (Scenario)scenarioList.getSelectedValue();
            if (scenario != null) {
                scenarioModel.setSelectedItem(scenario);
                selectedScenario = scenario;
                Component comp = (Component)uiCompMap.get(selectedScenario);
                if (comp == null) {
                    comp = scenario.getCustomizer(dataObject,false);
                    uiCompMap.put(selectedScenario, comp);
                }
                curScenarioPanel.add(comp, java.awt.BorderLayout.CENTER);
            } else {
                scenarioModel.setSelectedItem(null);
                selectedScenario = null;
            }
            
            revalidate();
            repaint();
            enableControls();
        }
    }//GEN-LAST:event_scenarioListValueChanged
    
    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        
        int selInd = scenarioModel.getIndexOf(selectedScenario);
        if (selInd == scenarioModel.getSize() - 1) {
            selInd--;
        }
        
        Object toRemove = selectedScenario;
        if(!m_addedScenarios.contains(toRemove)) {
            // if item existed befor dialog started up, add to list of deleted items
            m_deletedScenarios.add(toRemove);
        } else {
            // it item was added after dialog startup, remove from list of added items
            m_addedScenarios.remove(toRemove);
        }
        scenarioList.clearSelection();
        scenarioModel.removeElement(toRemove);
        
        if (selInd >= 0) {
            scenarioList.setSelectedIndex(selInd);
        }
        
        enableControls();
        
    }//GEN-LAST:event_removeButtonActionPerformed
    
    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        createScenario();
    }//GEN-LAST:event_addButtonActionPerformed
    

    
    /** A list of Scenarios deleted since dialog startup, needed to rollback actions when "Cancel" pressed */
    private Vector m_deletedScenarios = new Vector();
    /** A list of Scenarios added since dialog startup, needed to rollback actions when "Cancel" pressed */
    private Vector m_addedScenarios = new Vector();
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel curScenarioPanel;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JList scenarioList;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton addButton;
    private javax.swing.JButton renameButton;
    private javax.swing.JButton removeButton;
    // End of variables declaration//GEN-END:variables
    
    
    private void enableControls() {
        removeButton.setEnabled(selectedScenario != null);
        renameButton.setEnabled(selectedScenario != null);
    }
    
    
    private class NamePanel extends JPanel {
        private JTextField nameField;
        
        public NamePanel() {
            add(new JLabel(Util.THIS.getString("LBL_Rename_panel_name")));
            
            nameField = new JTextField(30);
            add(nameField);
        }
        
        public void setName(String name) {
            nameField.setText(name);
        }
        
        public String getName() {
            return nameField.getText();
        }
    }
}
