/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.asm.core.ui.top;

import javax.swing.AbstractListModel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;

import org.netbeans.modules.asm.model.AsmModel;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class InstructionListPanel extends JPanel implements NavigatorTab {
             
    private static NavigatorTab instance;        
    
    private AsmModel model;
    private InstructionInfoPanel info;
    
    public static synchronized NavigatorTab getInstance() {
        if (instance == null) {
            instance = new InstructionListPanel();
        }
        return instance;
    }       
    
    private InstructionListPanel() {
        this.model = model;   
        this.info = new InstructionInfoPanel();
        initComponents();
        
        add(info);
        
        setEnabled(false);
                
        jInstructionList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                int idx = e.getFirstIndex();
                info.setInstruction(InstructionListPanel.this.model.getInstructionSet().
                                    get(idx));
            }
        });
    }
    
    
    public void setDocument(DataObject dob) {
       this.model = AsmObjectUtilities.getModel(dob);
        
        if (model != null) {
            setEnabled(true);            
        }
        
        jInstructionList.setModel(new InstructionListModel());
    }
    
    public String getName() {
        return NbBundle.getMessage(InstructionListPanel.class, "CTL_INSTR_NAME");
    }
    
    public JPanel getPanel() {
        return this;
    }
    
    private class InstructionListModel extends AbstractListModel {        
        public int getSize() {
            if (model == null) {
                return 0;
            }
            
            return model.getInstructionSet().size();
        }

        public Object getElementAt(int index) {
            return model.getInstructionSet().get(index);
        }        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jInstructionListScrollPane = new javax.swing.JScrollPane();
        jInstructionList = new javax.swing.JList();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        jInstructionListScrollPane.setAutoscrolls(true);
        jInstructionList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jInstructionList.setVisibleRowCount(10);
        jInstructionListScrollPane.setViewportView(jInstructionList);

        add(jInstructionListScrollPane);

    }// </editor-fold>//GEN-END:initComponents
       
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jInstructionList;
    private javax.swing.JScrollPane jInstructionListScrollPane;
    // End of variables declaration//GEN-END:variables
    
}
