/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package examples.clock;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Calendar;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;

public class ClockFrame extends javax.swing.JFrame {

    /** Initializes the Form */
    public ClockFrame() {
        initComponents ();
        pack ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        tmrSeconds = new org.netbeans.examples.lib.timerbean.Timer();
        jlblCurrentTime = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jlblNewTime = new javax.swing.JLabel();
        jtfNewTime = new javax.swing.JTextField();
        jbtnNewTime = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jlblNewFormat = new javax.swing.JLabel();
        jtfNewTimeFormat = new javax.swing.JTextField();
        jbtnNewTimeFormat = new javax.swing.JButton();

        tmrSeconds.addTimerListener(new org.netbeans.examples.lib.timerbean.TimerListener() {
            public void onTime(java.awt.event.ActionEvent evt) {
                tmrSecondsOnTime(evt);
            }
        });

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jlblCurrentTime.setText("00:00:00");
        jlblCurrentTime.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlblCurrentTime.setFont(new java.awt.Font("Dialog", 1, 36));
        getContentPane().add(jlblCurrentTime, java.awt.BorderLayout.CENTER);

        jPanel1.setLayout(new java.awt.GridLayout(1, 0));

        jlblNewTime.setText("New Time");
        jlblNewTime.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jPanel1.add(jlblNewTime);

        jtfNewTime.setText("00:00:00");
        jPanel1.add(jtfNewTime);

        jbtnNewTime.setText("Set New Time");
        jbtnNewTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbtnSetNewTimeClicked(evt);
            }
        });

        jPanel1.add(jbtnNewTime);

        getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setLayout(new java.awt.GridLayout(1, 0));

        jlblNewFormat.setText("Time Format");
        jlblNewFormat.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jPanel2.add(jlblNewFormat);

        jtfNewTimeFormat.setText("hh:mm:ss");
        jPanel2.add(jtfNewTimeFormat);

        jbtnNewTimeFormat.setText("Set New Time Format");
        jbtnNewTimeFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbtnNewTimeFormatActionClicked(evt);
            }
        });

        jPanel2.add(jbtnNewTimeFormat);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    private void jbtnNewTimeFormatActionClicked (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbtnNewTimeFormatActionClicked
        String timeFormat = jtfNewTimeFormat.getText();
        formatter = new SimpleDateFormat(timeFormat);
    }//GEN-LAST:event_jbtnNewTimeFormatActionClicked

    private void jbtnSetNewTimeClicked (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbtnSetNewTimeClicked
        try {
            String timeStr = jtfNewTime.getText();
            gCal.setTime(formatter.parse(timeStr));
        } catch (java.text.ParseException e) {
            JOptionPane.showMessageDialog(this, "Invalid date format", "I don't understand your date format.", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jbtnSetNewTimeClicked

    private void tmrSecondsOnTime (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tmrSecondsOnTime
        gCal.add(Calendar.SECOND,1);
        String timeTxt = formatter.format(gCal.getTime());
        if (jlblCurrentTime != null)
            jlblCurrentTime.setText(timeTxt);
    }//GEN-LAST:event_tmrSecondsOnTime

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit (0);
    }//GEN-LAST:event_exitForm


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jbtnNewTime;
    private javax.swing.JButton jbtnNewTimeFormat;
    private javax.swing.JTextField jtfNewTime;
    private javax.swing.JLabel jlblNewTime;
    private javax.swing.JLabel jlblNewFormat;
    private javax.swing.JLabel jlblCurrentTime;
    private org.netbeans.examples.lib.timerbean.Timer tmrSeconds;
    private javax.swing.JTextField jtfNewTimeFormat;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    private GregorianCalendar gCal = new GregorianCalendar();
    private String timeFormat = "hh:mm:ss";
    private SimpleDateFormat formatter = new SimpleDateFormat(timeFormat);


    public static void main(java.lang.String[] args) {
        new ClockFrame ().show ();
    }

}
