/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.openide.util.lookup;

import org.openide.util.*;

import java.util.*;
import junit.framework.*;
import org.netbeans.junit.*;

public class AbstractLookupArrayStorageTest extends AbstractLookupBaseHid {
    public AbstractLookupArrayStorageTest(java.lang.String testName) {
        super(testName, null);
    }

    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite ());
    }

    public static TestSuite suite () {
        NbTestSuite suite = new NbTestSuite ();
        suite.addTest (new PL (2));
        suite.addTest (new AL (1));
        suite.addTest (new AL (-1));
        suite.addTest (new PL (-1));
        suite.addTest (new AL (5));
        suite.addTest (new PL (3));
        suite.addTest (new AL (2000));
        suite.addTest (new PL (2000));
        return suite;
    }

    public static final class AL extends ArrayTestSuite {
        public AL (int trash) {
            super (trash);
        }
        
        public Lookup createLookup (Lookup lookup) {
            return lookup;
        }
        
        public void clearCaches () {
        }
        
    }
    
    public static final class PL extends ArrayTestSuite {
        public PL (int trash) {
            super (trash);
        }
        
        public Lookup createLookup (Lookup lookup) {
            return  new ProxyLookup (new Lookup[] { lookup });
        }
        
        public void clearCaches () {
        }
        
    }
    
    private static abstract class ArrayTestSuite extends NbTestSuite 
    implements AbstractLookupBaseHid.Impl {
        private int trash;
        
        public ArrayTestSuite (int trash) {
            super (AbstractLookupArrayStorageTest.class);
            this.trash = trash;
            
            int cnt = this.countTestCases();
            for (int i = 0; i < cnt; i++) {
                Object o = this.testAt (i);
                AbstractLookupBaseHid t = (AbstractLookupBaseHid)o;
                t.impl = this;
            }
        }
        
        public Lookup createInstancesLookup (InstanceContent ic) {
            if (trash == -1) {
                return new AbstractLookup (ic, new ArrayStorage ());
            } else {
                return new AbstractLookup (ic, new ArrayStorage (new Integer (trash)));
            }
        }
        
        
    }
}
