/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.profiler.attach.panels.components;

import java.awt.Color;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class ComboSelector extends javax.swing.JPanel implements ListDataListener {
    public static final String LAYOUT_CHANGED_PROPERTY = DirectorySelector.class.getName() + "#LAYOUT_CHANGED";

    private String emptyModelMessage;
    private ComboBoxModel customModel;
    private boolean isEmptyModel;
    final private ComboBoxModel emptyModel = new ComboBoxModel() {

        public void addListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            return getEmptyModelMessage();
        }

        public Object getSelectedItem() {
            return getEmptyModelMessage();
        }

        public int getSize() {
            return 1;
        }

        public void removeListDataListener(ListDataListener l) {
        }

        public void setSelectedItem(Object anItem) {
        }
    };
    private boolean emptySelectorDisabled;

    /** Creates new form ComboSelector */
    public ComboSelector() {
        isEmptyModel = true;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        selector = new javax.swing.JComboBox();
        hintPanel = new org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel();

        selector.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        hintPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(selector, 0, 298, Short.MAX_VALUE)
            .add(hintPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 298, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(selector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(hintPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 42, Short.MAX_VALUE))
        );

        selector.getAccessibleContext().setAccessibleName("null");
        selector.getAccessibleContext().setAccessibleDescription("null");
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel hintPanel;
    private javax.swing.JComboBox selector;
    // End of variables declaration//GEN-END:variables
    // <editor-fold defaultstate="collapsed" desc="ListDataListener implementation">
    public void intervalAdded(ListDataEvent e) {
        updateModelProxy();
    }

    public void intervalRemoved(ListDataEvent e) {
        updateModelProxy();
    }

    public void contentsChanged(ListDataEvent e) {
        updateModelProxy();
    }
    // </editor-fold>
    public String getHint() {
        return hintPanel.getHint();
    }

    public void setHint(String hint) {
        hintPanel.setHint(hint);
        if (hint == null || hint.length() == 0) {
            hintPanel.setVisible(false);
        } else {
            hintPanel.setVisible(true);
        }
        firePropertyChange(LAYOUT_CHANGED_PROPERTY, null, null);
    }

    public ComboBoxModel getModel() {
        return this.customModel;
    }

    public void setModel(ComboBoxModel model) {
        this.customModel = model;
        updateModelProxy();
    }

    public Object getSelectedItem() {
        if (isEmptyModel) {
            return null;
        }
        if (getModel().getSelectedItem() == null && getModel().getSize() > 0) {
            getModel().setSelectedItem(getModel().getElementAt(0));
        }
        return getModel().getSelectedItem();
    }

    public String getEmptyModelMessage() {
        return emptyModelMessage;
    }

    public void setEmptyModelMessage(String message) {
        emptyModelMessage = message;
    }

    public boolean isDisableEmptySelector() {
        return emptySelectorDisabled;
    }

    public void setDisableEmptySelector(boolean value) {
        emptySelectorDisabled = value;
    }

    public Color getHintForeground() {
        return hintPanel.getForeground();
    }

    public void setHintForeground(Color color) {
        hintPanel.setForeground(color);
    }

    public Color getHintBackground() {
        return hintPanel.getBackground();
    }

    public void setHintBackground(Color bgcolor) {
        hintPanel.setBackground(bgcolor);
    }

    private void updateModelProxy() {
        if (customModel.getSize() > 0) {
            isEmptyModel = false;
            if (emptySelectorDisabled) {
                selector.setEnabled(true);
            }
            selector.setModel(customModel);
        } else {
            isEmptyModel = true;
            if (emptySelectorDisabled) {
                selector.setEnabled(false);
            }
            selector.setModel(emptyModel);
        }
        selector.invalidate();
    }
}
