/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.profiler.selector.ui;

import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;


/**
 *
 * @author Jaroslav Bachorik
 */
public interface ProgressDisplayer {
    //~ Inner Interfaces ---------------------------------------------------------------------------------------------------------

    public static interface ProgressController extends Cancellable {
    }

    //~ Static fields/initializers -----------------------------------------------------------------------------------------------

    public static final ProgressDisplayer DEFAULT = new ProgressDisplayer() {
        ProgressHandle ph = null;

        public synchronized void showProgress(String message) {
            ph = ProgressHandleFactory.createHandle(message);
            ph.start();
        }

        public synchronized void showProgress(String message, ProgressController controller) {
            ph = ProgressHandleFactory.createHandle(message, controller);
            ph.start();
        }

        public synchronized void showProgress(String caption, String message, ProgressController controller) {
            ph = ProgressHandleFactory.createHandle(message, controller);
            ph.start();
        }

        public synchronized boolean isOpened() {
            return ph != null;
        }

        public synchronized void close() {
            if (ph != null) {
                ph.finish();
                ph = null;
            }
        }
    };


    //~ Methods ------------------------------------------------------------------------------------------------------------------

    public boolean isOpened();

    public void close();

    public void showProgress(String message);

    public void showProgress(String message, ProgressController controller);

    public void showProgress(String caption, String message, ProgressController controller);
}
