/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * CssWebPreviewPanel.java
 *
 * Created on 4.9.2009, 10:35:38
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.filechooser.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.core.browser.api.EmbeddedBrowserFactory;
import org.netbeans.core.browser.api.WebBrowser;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/**
 *
 * @author Milan Kubec
 */
public class CssWebPreviewPanel extends javax.swing.JPanel implements CssPreviewComponent {

    private WebBrowser browser;

    private FileFilter filter = new HTMLFileFilter();

    private Map<String,File> urlToFile = new HashMap<String,File>();

    private String currentUrl;

    private boolean browserDisposed = false;

    /** Creates new form CssWebPreviewPanel */
    public CssWebPreviewPanel() {
        initComponents();
        if (EmbeddedBrowserFactory.getDefault().isEnabled()) {
            browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            add(browser.getComponent(), BorderLayout.CENTER);
        } else {
            // show some error panel ???
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        browseButton = new javax.swing.JButton();
        filenameLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        browseButton.setText(org.openide.util.NbBundle.getMessage(CssWebPreviewPanel.class, "CssWebPreviewPanel.browseButton.text")); // NOI18N
        browseButton.setToolTipText(org.openide.util.NbBundle.getMessage(CssWebPreviewPanel.class, "DifferentPreviewFile_Tooltip")); // NOI18N
        browseButton.setMargin(new java.awt.Insets(2, 4, 2, 4));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(browseButton, gridBagConstraints);

        filenameLabel.setText(org.openide.util.NbBundle.getMessage(CssWebPreviewPanel.class, "CssWebPreviewPanel.filenameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel1.add(filenameLabel, gridBagConstraints);

        add(jPanel1, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        JFileChooser chooser = new JFileChooser ();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(CssWebPreviewPanel.class, "WebPreviewChooserTitle"));
        chooser.setFileSelectionMode (JFileChooser.FILES_AND_DIRECTORIES);
        chooser.setFileFilter(filter);
        if ( JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) { //NOI18N
            File previewFile = chooser.getSelectedFile();
            try {
                if (previewFile.exists() && previewFile.isFile()) {
                    urlToFile.put(currentUrl, previewFile);
                    String urlString = previewFile.toURI().toURL().toExternalForm();
                    browser.setURL(urlString);
                    filenameLabel.setText(previewFile.getName());
                    filenameLabel.setToolTipText(urlString);
                }
            } catch (MalformedURLException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    public void setDocument(InputStream is, String url) throws Exception {
        currentUrl = url;
        if (browser == null) {
            return;
        } else {
            File file = urlToFile.get(url);
            if (file != null) {
                String urlString = file.toURI().toURL().toExternalForm();
                browser.setURL(urlString);
                filenameLabel.setText(file.getName());
                filenameLabel.setToolTipText(urlString);
                return;
            }
            browser.setContent(getContentFromReader(new BufferedReader(new InputStreamReader(is))));
            filenameLabel.setText(NbBundle.getMessage(CssWebPreviewPanel.class, "FileNameLabelText"));
            filenameLabel.setToolTipText(NbBundle.getMessage(CssWebPreviewPanel.class, "FileNameLabelTooltip"));
        }
    }

    public JComponent getComponent() {
        if ((browserDisposed || browser == null) && EmbeddedBrowserFactory.getDefault().isEnabled()) {
            browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            add(browser.getComponent(), BorderLayout.CENTER);
            revalidate();
            repaint();
            browserDisposed = false;
        }
        return this;
    }

    public void dispose() {
        browserDisposed = true;
        browser.dispose();
    }

    private String getContentFromReader(BufferedReader reader) {
        StringBuffer strBuff = new StringBuffer();
        String line = null;
        try {
            line = reader.readLine();
            while (line != null) {
                strBuff.append(line);
                line = reader.readLine();
            }
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
        return strBuff.toString();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JLabel filenameLabel;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    class HTMLFileFilter extends FileFilter {

        public boolean accept(File pathname) {
            return pathname.isDirectory() ||
                   pathname.toString().endsWith("html") ||
                   pathname.toString().endsWith("xhtml");
        }

        public String getDescription() {
            return NbBundle.getMessage(CssWebPreviewPanel.class, "WebPreviewFileFilterDesc");
        }

    }

}
