/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.test.db.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import org.netbeans.modules.derby.DbURLClassLoader;
import org.netbeans.modules.derby.DerbyOptions;
import org.openide.util.Exceptions;

/**
 *
 * @author luke
 */
public class DbUtil {
    public static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver";
    
    public static Connection createDerbyConnection(String dbURL) {
        // Derby Installation folder
        String location = DerbyOptions.getDefault().getLocation();
        File clientJar = new File(location, "lib/derbyclient.jar");
        Connection con = null;
        try {
            System.out.println("> Creating Derby connection using: "+clientJar.toURL());
            URL[] driverURLs = new URL[]{clientJar.toURL()};
            DbURLClassLoader loader = new DbURLClassLoader(driverURLs);
            Driver driver = (Driver) Class.forName(DRIVER_CLASS_NAME, true, loader).newInstance();
            con = driver.connect(dbURL, null);
        } catch (MalformedURLException ex) {
            Exceptions.attachMessage(ex, "Cannot convert to URL: "+clientJar);
            Exceptions.printStackTrace(ex);
        } catch (SQLException ex) {
            Exceptions.attachMessage(ex, "Cannot conect to: "+dbURL);
            Exceptions.printStackTrace(ex);
        } catch (InstantiationException ex) {
            Exceptions.attachMessage(ex, "Cannot instantiate: "+DRIVER_CLASS_NAME+" from: "+clientJar);
            Exceptions.printStackTrace(ex);
        } catch (IllegalAccessException ex) {
            Exceptions.attachMessage(ex, "Cannot instantiate: "+DRIVER_CLASS_NAME+" from: "+clientJar);
            Exceptions.printStackTrace(ex);
        } catch (ClassNotFoundException ex) {
            Exceptions.attachMessage(ex, "Cannot obtain: "+DRIVER_CLASS_NAME+" from: "+clientJar);
            Exceptions.printStackTrace(ex);
        }
        return con;
    }
    
}
