/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TargetSelector.java
 *
 * Created on 10.02.2010, 11:00:28
 */
package org.netbeans.nativeexecution.terminal.ui;

import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;

/**
 *
 * @author ak119685
 */
public final class TargetSelector extends javax.swing.JPanel {

    private String username;
    private String host;

    /** Creates new form TargetSelector */
    public TargetSelector() {
        initComponents();

        remoteBtn.setSelected(true);
        username = System.getProperty("user.name");
        host = "";
        terminalIO.setSelected(true);
        ptyMode.setSelected(true);
        reenableFields();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        remoteBtn = new javax.swing.JRadioButton();
        localBtn = new javax.swing.JRadioButton();
        terminalIO = new javax.swing.JCheckBox();
        ptyMode = new javax.swing.JCheckBox();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel2 = new javax.swing.JLabel();
        loginNameFld = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        hostNameFld = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        cmdFld = new javax.swing.JTextField();

        buttonGroup1.add(remoteBtn);
        org.openide.awt.Mnemonics.setLocalizedText(remoteBtn, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.remoteBtn.text")); // NOI18N
        remoteBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                remoteBtnActionPerformed(evt);
            }
        });

        buttonGroup1.add(localBtn);
        org.openide.awt.Mnemonics.setLocalizedText(localBtn, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.localBtn.text")); // NOI18N
        localBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                localBtnActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(terminalIO, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.terminalIO.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(ptyMode, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.ptyMode.text")); // NOI18N

        jLabel2.setLabelFor(loginNameFld);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.jLabel2.text")); // NOI18N

        jLabel1.setLabelFor(hostNameFld);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.jLabel1.text")); // NOI18N

        jLabel3.setLabelFor(cmdFld);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(TargetSelector.class, "TargetSelector.jLabel3.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel1)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cmdFld, javax.swing.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                            .addComponent(hostNameFld, javax.swing.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                            .addComponent(loginNameFld, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(remoteBtn)
                            .addComponent(localBtn))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(ptyMode)
                            .addComponent(terminalIO))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(remoteBtn)
                    .addComponent(terminalIO))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(localBtn)
                    .addComponent(ptyMode))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(loginNameFld, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hostNameFld, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addGap(34, 34, 34)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cmdFld, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void remoteBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_remoteBtnActionPerformed
        reenableFields();
    }//GEN-LAST:event_remoteBtnActionPerformed

    private void localBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_localBtnActionPerformed
        reenableFields();
    }//GEN-LAST:event_localBtnActionPerformed

    private void reenableFields() {
        boolean enable = remoteBtn.isSelected();

        if (enable) {
            loginNameFld.setText(username);
            hostNameFld.setText(host);
        } else {
            username = loginNameFld.getText();
            host = hostNameFld.getText();
            loginNameFld.setText(System.getProperty("user.name"));
            hostNameFld.setText("localhost");
        }

        loginNameFld.setEditable(enable);
        loginNameFld.setFocusable(enable);
        hostNameFld.setEditable(enable);
        hostNameFld.setFocusable(enable);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        if (localBtn.isSelected()) {
            return ExecutionEnvironmentFactory.getLocal();
        }

        return ExecutionEnvironmentFactory.createNew(loginNameFld.getText(), hostNameFld.getText());
    }

    public String getCmd() {
        return cmdFld.getText().trim();
    }

    public boolean isTerminalIO() {
        return terminalIO.isSelected();
    }

    public boolean isPtyMode() {
        return ptyMode.isSelected();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextField cmdFld;
    private javax.swing.JTextField hostNameFld;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton localBtn;
    private javax.swing.JTextField loginNameFld;
    private javax.swing.JCheckBox ptyMode;
    private javax.swing.JRadioButton remoteBtn;
    private javax.swing.JCheckBox terminalIO;
    // End of variables declaration//GEN-END:variables
}
