/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s): theanuradha@netbeans.org
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.maven.actions.scm;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.actions.ActionsUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

/**
 * @deprecated Replaced by actions in Artifact viewer window, see #164992
 * @author Anuradha G 
 */
public class SCMActions extends AbstractAction  implements Presenter.Popup{
    private Artifact artifact;
    private List<ArtifactRepository> repos;
   
    public SCMActions(Artifact artifact, List<ArtifactRepository> repos) {
        putValue(NAME, NbBundle.getMessage(SCMActions.class, "LBL_SCM"));//NOI18N
        this.artifact = artifact;
        this.repos = repos;
    }
    
    
    @Override
    public void actionPerformed(ActionEvent e) {
        //ignore
    }

    @Override
    public JMenuItem getPopupPresenter() {
        //TODO - start reading in some other thread and just wait for it to finish here..
        // how to do nicely?
        final InstanceContent ic = new InstanceContent();
        AbstractLookup lookup = new AbstractLookup(ic);
        RequestProcessor.getDefault().post(new Runnable() {
            @Override
            public void run() {
                MavenProject readMavenProject = ActionsUtil.readMavenProject(artifact, repos);
                ic.add(readMavenProject);
            }
        });

        JMenu menu = new JMenu(NbBundle.getMessage(SCMActions.class, "LBL_SCM"));
        menu.add(new OpenScmURLAction(artifact, repos));
        Action act = new CheckoutAction(lookup);
        act.putValue(SMALL_ICON, null);
        menu.add(act);
        return menu;
    }

}
