/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/**
 *
 * @author thp
 */
public class ManDocumentation {

//    private static final Logger LOG = Logger.getLogger(ManDocumentation.class.getName());
//    private static String manPath = null;
//
//    private static String getPath(String cmd) {
//        String path = null;
//        path = Path.findCommand(cmd);
//        if (path == null) {
//            if (new File("/usr/bin/" + cmd).exists()) { // NOI18N
//                path = "/usr/bin/" + cmd; // NOI18N
//            }
//        }
//        if (path == null) {
//            if (new File("/bin/" + cmd).exists()) { // NOI18N
//                path = "/bin/" + cmd; // NOI18N
//            }
//        }
//        return path;
//    }
//
//    private static String getManPath() {
//        if (manPath == null) {
//            manPath = getPath("man"); // NOI18N
//        }
//        return manPath;
//    }
    public static CompletionDocumentation getDocumentation(CsmObject obj, CsmFile file) throws IOException {
        if (CsmKindUtilities.isFunction(obj) && !CsmKindUtilities.isClassMember(obj)) {
            CsmFunction function = (CsmFunction) obj;
            return getDoc(function.getQualifiedName().toString(), file);
        } else if (CsmKindUtilities.isClass(obj)) {
            CsmClass cls = (CsmClass) obj;
            return getDoc(cls.getQualifiedName().toString(), file);
        } else if (CsmKindUtilities.isClassMember(obj)) {
            CsmScope scope = ((CsmMember) obj).getScope();
            if (CsmKindUtilities.isClass(scope)) {
                CsmClass cls = (CsmClass) scope;
                return getDoc(cls.getQualifiedName().toString(), file);
            }
        }
        return null;
    }

    private static CompletionDocumentation getDoc(String name, CsmFile file) throws IOException {
        if (name.indexOf('<') > 0) { //NOI18N
            name = name.substring(0, name.indexOf('<')); //NOI18N
        }
        try {
            CompletionDocumentation documentation = getDocumentation(name, file);
            if (documentation != null) {
                return documentation;
            }
        } catch (IOException ex) {
            if (!name.contains("::")) { //NOI18N
                throw ex;
            }
            // try name
        }
        if (name.contains("::")) { //NOI18N
            name = name.substring(name.lastIndexOf(':')+1); //NOI18N
            return getDocumentation(name, file);
        }
        return null;
    }

    public static CompletionDocumentation getDocumentation(String name, CsmFile file) throws IOException {
        return getDocumentation(name, 3, file);
        /**Supposing all functions goes from chapter 3*/
    }

    public static CompletionDocumentation getDocumentation(String name, int chapter, CsmFile file) throws IOException {
        String doc = getDocumentationForName(name, chapter, file);

        if (doc == null) {
            return null;
        }

        return new CompletionDocumentationImpl(doc, file);
    }

    public static String getDocumentationForName(String name, int chapter, CsmFile file) throws IOException {
        NativeProject np = getNativeProject(file);
        if (np == null) {
            return "";
        }
        String platformName = NativeProjectSupport.getPlatformName(np);
        File cache = getCacheFile(name, chapter, platformName);

        if (cache.exists()) {
            return readFile(cache);
        }

        String doc = createDocumentationForName(name, chapter, np);

        if (doc != null) {
            OutputStream out = null;

            try {
                out = new FileOutputStream(cache);

                out.write(doc.getBytes());
            } catch (IOException e) {
                Exceptions.printStackTrace(e);
            } finally {
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                }
            }

            return doc;
        }

        return null;
    }

//    public static String constructWarning(CsmObject obj) {
//        if (obj instanceof CsmFunction) {
//            StringBuilder w = new StringBuilder();
//
//            if (getManPath() == null) { // NOI18N
//                w.append("<p>"); // NOI18N
//                w.append(getString("MAN_NOT_INSTALLED")); // NOI18N
//                w.append("</p>\n"); // NOI18N
//            }
//
//            return w.toString();
//        }
//
//        return "";
//    }
    private static File getCacheFile(String name, int chapter, String platformName) {
        // name might look like "operator /=", so we need to escape it
        String safeName;
        try {
            safeName = URLEncoder.encode(name, "UTF-8"); // NOI18N
        } catch (UnsupportedEncodingException ex) {
            // UTF-8 should always be supported, but anyway...
            safeName = name;
        }
        return Places.getCacheSubfile("cnd/manpages/" + safeName + "." + platformName + "." + chapter); // NOI18N
    }

    static NativeProject getNativeProject(CsmFile csmFile) {
        NativeProject nativeProject = null;
        if (csmFile != null) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject.getPlatformProject() instanceof NativeProject) {
                nativeProject = (NativeProject) csmProject.getPlatformProject();
            } else {
                loop:
                for (CsmProject project : CsmModelAccessor.getModel().projects()) {
                    for (CsmProject lib : project.getLibraries()) {
                        if (lib.equals(csmProject)) {
                            if (project.getPlatformProject() instanceof NativeProject) {
                                nativeProject = (NativeProject) project.getPlatformProject();
                                break loop;
                            }
                        }
                    }
                }
            }
        }
        return nativeProject;
    }

    private static String createDocumentationForName(String name, int chapter, NativeProject np) throws IOException {
        NativeExitStatus exitStatus;
        String platformName = NativeProjectSupport.getPlatformName(np);
        if (platformName == null) {
            exitStatus = NativeProjectSupport.execute(np, "man", new String[]{"MANWIDTH=" + Man2HTML.MAX_WIDTH}, name); // NOI18N
        } else if (platformName.contains("Solaris")) { // NOI18N
            NativeExitStatus es = NativeProjectSupport.execute(np, "man", new String[]{}, "-l", name); // NOI18N
            String section = getSection(es.output, "(2"); // NOI18N
            if (section == null) {
                section = getSection(es.output, "(3"); // NOI18N
            }
            if (section != null) {
                exitStatus = NativeProjectSupport.execute(np, "man", null, "-s" + section, name); // NOI18N
            } else {
                exitStatus = NativeProjectSupport.execute(np, "man", null, name); // NOI18N
            }
        } else {
            // Current host locale is used here, because user possibly wants to see man pages 
            // in locale of his development host, not in remote's host one.
            final String DOT_UTF8 = ".UTF-8";  // NOI18N
            exitStatus = NativeProjectSupport.execute(np, "man", new String[]{"MANWIDTH=" + Man2HTML.MAX_WIDTH, "LANG=" + Locale.getDefault().toString().trim().replace(DOT_UTF8, "") + DOT_UTF8}, "-S2:3", name); // NOI18N
        }
        StringReader sr;
        if (exitStatus != null) {
            if (exitStatus.isOK() && exitStatus.output.length() > 0) {
                if (exitStatus.output.split("\n").length <= 2) { // NOI18N
                    return null;
                }
                sr = new StringReader(exitStatus.output);
            } else {
                throw new IOException(exitStatus.error);
            }
        } else {
            return null;
        }
        BufferedReader br = new BufferedReader(sr);
        String text = new Man2HTML(br).getHTML();
        br.close();
        sr.close();
        return text;
    }

    private static String getSection(String output, String number) {
        String section = null;
        int index1 = output.indexOf(number);
        int index2;
        while (section == null && index1 >= 0) {
            if (output.charAt(index1 + 2) != 'f') { // Don't want fortran!
                index2 = output.substring(index1).indexOf(")"); // NOI18N
                section = output.substring(index1 + 1, index1 + index2);
                break;
            }
            output = output.substring(index1 + 1);
            index1 = output.indexOf(number);
        }
        return section;
    }
    
    private static final Map<String, String> TRANSLATE;

    static {
        TRANSLATE = new HashMap<String, String>();

        TRANSLATE.put("&minus;", "-"); // NOI18N
        TRANSLATE.put("&lsquo;", "'"); // NOI18N
        TRANSLATE.put("&rsquo;", "'"); // NOI18N
    }

    private static String readFile(File f) throws IOException {
        InputStream fin = null;
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        try {
            fin = new FileInputStream(f);

            if (f.getName().endsWith(".gz")) { // NOI18N
                in = new GZIPInputStream(fin);
            } else {
                in = fin;
            }

            FileUtil.copy(in, out);

            return out.toString();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    Exceptions.printStackTrace(e);
                }
            }
            if (fin != null) {
                try {
                    fin.close();
                } catch (IOException e) {
                    Exceptions.printStackTrace(e);
                }
            }
            try {
                out.close();
            } catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    private static final class CompletionDocumentationImpl implements CompletionDocumentation {

        private String doc;
        private CsmFile file;

        public CompletionDocumentationImpl(String doc, CsmFile file) {
            this.doc = doc;
            this.file = file;
        }

        @Override
        public String getText() {
            return doc;
        }

        @Override
        public URL getURL() {
            return null;
        }

        @Override
        public CompletionDocumentation resolveLink(String link) {
            String[] parts = link.split("\\?"); // NOI18N

            if (parts.length != 2) {
                return null;
            }

            String[] chapterAndName = parts[1].split("\\+"); // NOI18N

            if (chapterAndName.length != 2) {
                return null;
            }

            int chapter = Integer.parseInt(chapterAndName[0]);
            String name = chapterAndName[1];

            try {
                return ManDocumentation.getDocumentation(name, chapter, file);
            } catch (IOException ioe) {
                return new CompletionDocumentationImpl(ioe.getMessage(), file);
            }
        }

        @Override
        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ManDocumentation.class).getString(s);
    }
}
