<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/cgroups.plugin/integrations/containers.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/cgroups.plugin/metadata.yaml"
sidebar_label: "Containers"
learn_status: "Published"
learn_rel_path: "Data Collection/Containers and VMs"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Containers


<img src="https://netdata.cloud/img/container.svg" width="150"/>


Plugin: cgroups.plugin
Module: /sys/fs/cgroup

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Containers for performance, resource usage, and health status.



This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per cgroup



Labels:

| Label      | Description     |
|:-----------|:----------------|
| container_name | The container name or group path if name resolution fails. |
| image | Docker/Podman container image name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cgroup.cpu_limit | used | percentage |
| cgroup.cpu | user, system | percentage |
| cgroup.cpu_per_core | a dimension per core | percentage |
| cgroup.throttled | throttled | percentage |
| cgroup.throttled_duration | duration | ms |
| cgroup.cpu_shares | shares | shares |
| cgroup.mem | cache, rss, swap, rss_huge, mapped_file | MiB |
| cgroup.writeback | dirty, writeback | MiB |
| cgroup.mem_activity | in, out | MiB/s |
| cgroup.pgfaults | pgfault, swap | MiB/s |
| cgroup.mem_usage | ram, swap | MiB |
| cgroup.mem_usage_limit | available, used | MiB |
| cgroup.mem_utilization | utilization | percentage |
| cgroup.mem_failcnt | failures | count |
| cgroup.io | read, write | KiB/s |
| cgroup.serviced_ops | read, write | operations/s |
| cgroup.throttle_io | read, write | KiB/s |
| cgroup.throttle_serviced_ops | read, write | operations/s |
| cgroup.queued_ops | read, write | operations |
| cgroup.merged_ops | read, write | operations/s |
| cgroup.cpu_some_pressure | some10, some60, some300 | percentage |
| cgroup.cpu_some_pressure_stall_time | time | ms |
| cgroup.cpu_full_pressure | some10, some60, some300 | percentage |
| cgroup.cpu_full_pressure_stall_time | time | ms |
| cgroup.memory_some_pressure | some10, some60, some300 | percentage |
| cgroup.memory_some_pressure_stall_time | time | ms |
| cgroup.memory_full_pressure | some10, some60, some300 | percentage |
| cgroup.memory_full_pressure_stall_time | time | ms |
| cgroup.io_some_pressure | some10, some60, some300 | percentage |
| cgroup.io_some_pressure_stall_time | time | ms |
| cgroup.io_full_pressure | some10, some60, some300 | percentage |
| cgroup.io_full_pressure_stall_time | time | ms |
| cgroup.pids_current | pids | pids |

### Per cgroup network device



Labels:

| Label      | Description     |
|:-----------|:----------------|
| container_name | The container name or group path if name resolution fails. |
| image | Docker/Podman container image name. |
| device | The name of the host network interface linked to the container's network interface. |
| container_device | Container network interface name. |
| interface_type | Network interface type. Always "virtual" for the containers. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cgroup.net_net | received, sent | kilobits/s |
| cgroup.net_packets | received, sent, multicast | pps |
| cgroup.net_errors | inbound, outbound | errors/s |
| cgroup.net_drops | inbound, outbound | errors/s |
| cgroup.net_fifo | receive, transmit | errors/s |
| cgroup.net_compressed | receive, sent | pps |
| cgroup.net_events | frames, collisions, carrier | events/s |
| cgroup.net_operstate | up, down, notpresent, lowerlayerdown, testing, dormant, unknown | state |
| cgroup.net_carrier | up, down | state |
| cgroup.net_mtu | mtu | octets |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ cgroup_10min_cpu_usage ](https://github.com/netdata/netdata/blob/master/health/health.d/cgroups.conf) | cgroup.cpu_limit | average cgroup CPU utilization over the last 10 minutes |
| [ cgroup_ram_in_use ](https://github.com/netdata/netdata/blob/master/health/health.d/cgroups.conf) | cgroup.mem_usage | cgroup memory utilization |
| [ cgroup_1m_received_packets_rate ](https://github.com/netdata/netdata/blob/master/health/health.d/cgroups.conf) | cgroup.net_packets | average number of packets received by the network interface ${label:device} over the last minute |
| [ cgroup_10s_received_packets_storm ](https://github.com/netdata/netdata/blob/master/health/health.d/cgroups.conf) | cgroup.net_packets | ratio of average number of received packets for the network interface ${label:device} over the last 10 seconds, compared to the rate over the last minute |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


