<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/tc.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/tc.plugin/metadata.yaml"
sidebar_label: "tc QoS classes"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/Network"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# tc QoS classes


<img src="https://netdata.cloud/img/netdata.png" width="150"/>


Plugin: tc.plugin
Module: tc.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Examine tc metrics to gain insights into Linux traffic control operations. Study packet flow rates, queue lengths, and drop rates to optimize network traffic flow.

The plugin uses `tc` command to collect information about Traffic control.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs to access command `tc` to get the necessary metrics. To achieve this netdata modifies permission of file `/usr/libexec/netdata/plugins.d/tc-qos-helper.sh`.

### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per network device direction

Metrics related to QoS network device directions. Each direction (in/out) produces its own set of the following metrics.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| device | The network interface. |
| device_name | The network interface name |
| group | The device family |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| tc.qos | a dimension per class | kilobits/s |
| tc.qos_packets | a dimension per class | packets/s |
| tc.qos_dropped | a dimension per class | packets/s |
| tc.qos_tokens | a dimension per class | tokens |
| tc.qos_ctokens | a dimension per class | ctokens |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Create `tc-qos-helper.conf`

In order to view tc classes, you need to create the file `/etc/netdata/tc-qos-helper.conf` with content:

```conf
tc_show="class"
```



### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:tc]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details><summary>Config option</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| script to run to get tc values | Path to script `tc-qos-helper.sh` | usr/libexec/netdata/plugins.d/tc-qos-helper.s | no |
| enable show all classes and qdiscs for all interfaces | yes/no flag to control what data is presented. | yes | no |

</details>

#### Examples

##### Basic

A basic example configuration using classes defined in `/etc/iproute2/tc_cls`.

An example of class IDs mapped to names in that file can be:

```conf
2:1 Standard
2:8 LowPriorityData
2:10 HighThroughputData
2:16 OAM
2:18 LowLatencyData
2:24 BroadcastVideo
2:26 MultimediaStreaming
2:32 RealTimeInteractive
2:34 MultimediaConferencing
2:40 Signalling
2:46 Telephony
2:48 NetworkControl
```

You can read more about setting up the tc rules in rc.local in this [GitHub issue](https://github.com/netdata/netdata/issues/4563#issuecomment-455711973).


```yaml
[plugin:tc]
  script to run to get tc values = /usr/libexec/netdata/plugins.d/tc-qos-helper.sh
  enable show all classes and qdiscs for all interfaces = yes

```

