SET(CMAKE_SYSTEM_NAME Windows)

IF(DEFINED ENV{USE_64BITS})
  SET(USE_64BITS $ENV{USE_64BITS})
ENDIF()

IF(USE_64BITS OR CMAKE_SIZEOF_VOID_P STREQUAL 8)
  SET(CROSSCOMPILER x86_64-w64-mingw32-)
ELSE()
  SET(CROSSCOMPILER i686-w64-mingw32-)
ENDIF()

IF($ENV{CROSSCOMPILER})
  SET(CROSSCOMPILER $ENV{CROSSCOMPILER})
ENDIF()


SET(CMAKE_C_COMPILER   ${CROSSCOMPILER}gcc)
SET(CMAKE_CXX_COMPILER ${CROSSCOMPILER}g++)
SET(CMAKE_STRIP        ${CROSSCOMPILER}strip)
SET(CMAKE_RC_COMPILER  ${CROSSCOMPILER}windres)


IF($ENV{CMAKE_FIND_ROOT_PATH})
  SET(CMAKE_FIND_ROOT_PATH ${CMAKE_FIND_ROOT_PATH})
ELSE()
  EXECUTE_PROCESS(COMMAND
    ${CMAKE_C_COMPILER} --print-sysroot OUTPUT_VARIABLE SYSROOT)
  IF($ENV{SYSROOT})
    SET(SYSROOT $ENV{SYSROOT})
  ENDIF()
  SET(CMAKE_FIND_ROOT_PATH ${SYSROOT})
ENDIF()

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

