%{
/* cmd_scanner.l

   Lexical analyzer for definition numeric specifications

   Copyright (C) 2007, 2008 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <dnet.h>

#include "cmd_parser.h"
#include "xstrdup.h"

%}

%option reentrant
%option bison-bridge
%option noyywrap
/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

%%

ghost		return GHOST;
with		return WITH;
ip		return IP;
and		return AND;
mac		return MAC;
on		return ON;
interface	return INTERFACE;
show		return SHOW;
version		return VERS;
dissection	return DISSECTION;
vars		return VARS;
packet		return PACKET;
ghosts		return GHOSTS;
info		return INFO;
kill		return KILL;

[^ \t]+	    {
		yylval->sval = xstrdup(yytext);
		return STRING;
	    }

[ \t]+		/* eat whitespace */

%%
