#ifndef FILE_AMG_PEBBLES
#define FILE_AMG_PEBBLES

/*********************************************************************/
/* File:   amg_pebbles.hpp                                           */
/* Author: Stefan Reitzinger, Joachim Schoeberl                      */
/* Date:   20. Feb. 2002                                             */
/*********************************************************************/



class PebblesMatrix : public BaseMatrix
{
  RS_AMG::OutBack * outback;
public:
  PebblesMatrix (const BilinearForm & bfa);
  virtual void Mult (const BaseVector & x, BaseVector & y) const;
};




class PebblesEdgeMatrix : public BaseMatrix
{
  RS_AMG::OutBack * outback;
  ARRAY<int> reorder;
public:
  PebblesEdgeMatrix (const BilinearForm & bfa,
		     const BilinearForm & bfl);
  virtual void Mult (const BaseVector & x, BaseVector & y) const;
};


class AMGPreconditioner : public Preconditioner
{
protected:
  ///
  BilinearForm * bfa;
  /// help matrix for edge elements (Laplace matrix)
  BilinearForm * bfl;
  ///
  BaseMatrix * pre;
public:
  ///
  AMGPreconditioner (PDE * pde, Flags & flags);
  ///
  ~AMGPreconditioner();
  ///
  virtual void Update ();
  ///
  virtual const ngla::BaseMatrix & GetMatrix() const
  {
    return *pre;
  }
  
  ///
  virtual const ngla::BaseMatrix & GetAMatrix() const
  {
    return bfa->GetMatrix(); 
  }
  ///
  virtual const char * ClassName() const
    { return "AMG Preconditioner"; }
};

#endif
