#ifndef FILE_H1HOFESPACE
#define FILE_H1HOFESPACE

/*********************************************************************/
/* File:   h1hofespace.hpp                                           */
/* Author: Start                                                     */
/* Date:   10. Feb. 2003                                             */
/*********************************************************************/

/**
   High Order Finite Element Space
*/


class H1HighOrderFESpace : public FESpace
{
private:
  
  // Level
  int level;

  // Number of Edges
  int ned;
  // Number of Faces
  int nfa;
  // Number of Elements
  int nel;
  // Number of Vertex
  int nv;

  ARRAY<int> first_edge_dof;
  ARRAY<int> first_face_dof;
  ARRAY<int> first_element_dof;

  /// relative order to mesh-order
  int rel_order; 

  ARRAY<int> order_edge;
  ARRAY<int> order_face;
  ARRAY<int> order_inner;

  int ndof;
  int uniform_order_inner;
  
  ARRAY<int> ndlevel;

  int augmented;

public:

  H1HighOrderFESpace (const MeshAccess & ama, const Flags & flags);
  ///
  virtual ~H1HighOrderFESpace ();

  static FESpace * Create (const MeshAccess & ma, const Flags & flags);

  virtual string GetClassName () const
  {
    return "H1HighOrderFESpace";
  }

  ///
  virtual void Update();
  ///
  virtual void PrintReport (ostream & ost);

  ///
  virtual int GetNDof () const;
  ///
  virtual int GetNDofLevel (int level) const;
  ///
  virtual const FiniteElement & GetFE (int elnr, LocalHeap & lh) const;
  ///
  virtual const FiniteElement & GetSFE (int elnr, LocalHeap & lh) const;
  ///
  virtual void GetDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetExternalDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetSDofNrs (int selnr, ARRAY<int> & dnums) const;
  
  virtual Table<int> * CreateSmoothingBlocks ( int type = 0) const;
  ///
  virtual ARRAY<int> * CreateDirectSolverClusters (int type = 0) const;

  ///
  int GetFirstFaceDof(int i) const {return(first_face_dof[i]);} ;  
  ///
  int GetFirstEdgeDof(int i) const {return(first_edge_dof[i]);} ; 
  ///
  int GetFirstElementDof(int i) const {return(first_element_dof[i]);} ; 

  void UpdateDofTables ();
  void SetEdgeOrder (int enr, int eo) { order_edge[enr] = eo; }
  void SetFaceOrder (int fnr, int fo) { order_face[fnr] = fo; }
  void SetElementOrder (int elnr, int elo) { order_inner[elnr] = elo; }
};

#endif

