#ifndef FILE_HDIVHOFESPACE

#define FILE_HDIVHOFESPACE

/*********************************************************************/
/* File:   hdivhofespace.hpp                                         */
/* Author: Sabine Zaglmayr                                           */
/* Date:   15. Feb. 2003                                             */
/*********************************************************************/

/**
   HDiv High Order Finite Element Space
*/


class HDivHighOrderFESpace : public FESpace
{
private:
  
  // Level
  int level;
  // Number of Edges
  int ned;
  // Number of Faces
  int nfa;
  // Number of Elements
  int nel;
  // Number of Vertex
  int nv;

  ARRAY<int> first_edge_dof;
  ARRAY<int> first_face_dof;
  ARRAY<int> first_inner_dof;


  /// relative order to mesh-order
  int rel_order; 

  ARRAY<int> order_edge;
  ARRAY<int> order_inner;
  ARRAY<int> order_face;

  int ndof;

public:

  HDivHighOrderFESpace (const MeshAccess & ama, const Flags & flags);
  ///
  virtual ~HDivHighOrderFESpace ();

  static FESpace * Create (const MeshAccess & ma, const Flags & flags);

  virtual string GetClassName () const
  {
    return "HDivHighOrderFESpace";
  }

  ///
  virtual void Update();
  ///
  virtual int GetNDof () const;
  ///
  virtual const FiniteElement & GetFE (int elnr, LocalHeap & lh) const;
  ///
  virtual const FiniteElement & GetSFE (int selnr, LocalHeap & lh) const; // 2D: array =0.;
  ///
  virtual void GetDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetExternalDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetSDofNrs (int selnr, ARRAY<int> & dnums) const;
  ///
  virtual Table<int> * CreateSmoothingBlocks ( int type = 0) const;
};

#endif





