#ifndef FILE_TOPOLOGY
#define FILE_TOPOLOGY

/*********************************************************************/
/* File:   topology.hpp                                              */
/* Author: Joachim Schoeberl                                         */
/* Date:   25. Mar. 2000                                             */
/*********************************************************************/

/*
    Toplogy of reference elements
*/


/**
   Geometry of element 
 */
enum ELEMENT_TYPE { ET_SEGM = 1,
		    ET_TRIG = 10, ET_QUAD = 11, 
		    ET_TET = 20, ET_PYRAMID = 21, ET_PRISM = 22, ET_HEX = 24 };

/// point coordinates
typedef double POINT3D[3];  

/// initial point, end point
typedef int EDGE[2];      

/// points, last one is -1 for trig
typedef int FACE[4];      


/// Topology and coordinate information of master element:
class ElementTopology
{
public:
  ///
  static const char * GetElementName (ELEMENT_TYPE et);

  ///
  static int GetSpaceDim (ELEMENT_TYPE et)
  {
    switch (et)
      {
      case ET_SEGM: return 1;
      case ET_TRIG: return 2;
      case ET_QUAD: return 2;
      case ET_TET: return 3;
      case ET_PYRAMID: return 3;
      case ET_PRISM: return 3;
      case ET_HEX: return 3;
      }
    return 0;
  }

  ///
  static int GetNVertices (ELEMENT_TYPE et)
  {
    switch (et)
      {
      case ET_SEGM: return 2;
      case ET_TRIG: return 3;
      case ET_QUAD: return 4;
      case ET_TET: return 4;
      case ET_PYRAMID: return 5;
      case ET_PRISM: return 6;
      case ET_HEX: return 8;
      }
    return 0;
  }

  ///
  static int GetNEdges (ELEMENT_TYPE et)
  { 
    switch (et)
      {
      case ET_SEGM: return 1;
      case ET_TRIG: return 3;
      case ET_QUAD: return 4;
      case ET_TET: return 6;
      case ET_PYRAMID: return 8;
      case ET_PRISM: return 9;
      case ET_HEX: return 12;
      }
    return 0;
  }


  ///
  static int GetNFaces (ELEMENT_TYPE et)
  {
    switch (et)
      {
      case ET_SEGM: return 0;
      case ET_TRIG: return 1;
      case ET_QUAD: return 1;
      case ET_TET: return 4;
      case ET_PYRAMID: return 5;
      case ET_PRISM: return 5;
      case ET_HEX: return 6;
      }  
    return 0;
  }

  ///
  static const POINT3D * GetVertices (ELEMENT_TYPE et);

  ///
  static const EDGE * GetEdges (ELEMENT_TYPE et);

  ///
  static const FACE * GetFaces (ELEMENT_TYPE et);

  ///
  static int GetEdgeNr (ELEMENT_TYPE et, int v1, int v2);

  ///
  static int GetFaceNr (ELEMENT_TYPE et, int v1, int v2, int v3);
};

#endif
