/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qstring.h>
#include <qvaluevector.h>

#ifndef PROFILE_H
#define PROFILE_H

// Class containing a profile's settings.
class Profile
{
	public:
		Profile();
		
		// Static method for importing the profiles from profiles.txt.
		static void fetchProfiles(); 
		
		// Static vector that stores all the profiles at runtime.
		static QValueVector<Profile> profiles; 
		
		// Debug function.
		static void dumpProfiles(); 
		
		// String-variables that stores the profile's network-settings.
		QString name;
		QString iface;
		QString ip;
		QString netmask;
		QString gw;
		QString ns1, ns2;
		QString search;
		
		QString scriptPath, script;
		QString mode;
		QString essid;
		QString key;
		QString keyType;
};

#endif
