#ifndef NEUTRINO_WAV_H
#define NEUTRINO_WAV_H

#include <glib-object.h>
#include "nomad-jukebox-track.h"

#include <libgnomevfs/gnome-vfs-handle.h>


#define NEUTRINO_TYPE_WAV  (neutrino_wav_get_type())
#define NEUTRINO_WAV(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              NEUTRINO_TYPE_WAV, \
                              NeutrinoWAV ) )
#define NEUTRINO_WAV_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
				      NEUTRINO_TYPE_WAV, \
                                      NeutrinoWAVClass ) )
#define NEUTRINO_IS_WAV(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 NEUTRINO_TYPE_WAV ) )

typedef struct {
	GObjectClass parent_spot;

} NeutrinoWAVClass;


typedef struct NeutrinoWAVDetails NeutrinoWAVDetails;

typedef struct  {
	GObject parent_object;

	NeutrinoWAVDetails *details;
} NeutrinoWAV;


GType  neutrino_wav_get_type( void );
NeutrinoWAV *neutrino_wav_new( const gchar *uri );

gchar *neutrino_wav_get_length( NeutrinoWAV *wav );



NomadTrack *neutrino_wav_track( const gchar *uri );
void neutrino_wav_tag_file( const gchar *uri, NomadTrack *track );


void *neutrino_wav_write_header( const gchar *uri );

#endif
