#include <stdio.h>

#include <libgnomevfs/gnome-vfs.h>

#include "id3/nomad-id3.h"

int main( int argc, char *argv[] )
{
	NomadID3 *id3;

	if( argc != 2 ) {
		printf( "Usage: id3read [file]\n" );
		return 0;
	}
	
	g_type_init();
	gnome_vfs_init();

	id3 = nomad_id3_new( argv[ 1 ] );

	g_print( "Title: %s\n", nomad_id3_get_title( id3 ) );
	g_print( "Album: %s\n", nomad_id3_get_album( id3 ) );
	g_print( "Artist: %s\n", nomad_id3_get_artist( id3 ) );
	
	g_object_unref( id3 );
	
	gnome_vfs_shutdown();
	
	return 0;
}
