/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigurePub.cpp: implementation of the DlgConfigurePub class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgConfigurePub.h"
#include "DlgAddPubMeth.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgConfigurePub, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigureEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
    EVT_COMBOBOX(IDC_CA, DlgConfigurePub::OnCaChanged)
    EVT_BUTTON(IDC_ADD_VALUE, DlgConfigurePub::OnAdd)
    EVT_BUTTON(IDC_MODIFY_VALUE, DlgConfigurePub::OnMod)
    EVT_BUTTON(IDC_DELETE_VALUE, DlgConfigurePub::OnDel)
    EVT_CHECKBOX(IDC_ENABLE_OCSP, DlgConfigurePub::OnActivateClick)
END_EVENT_TABLE()


DlgConfigurePub::DlgConfigurePub(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):DlgConfigureEntity(wParent, entity_cert, ClientPki)
{
	m_imageListSmall = NULL;


	DlgConfigurePub_SetWindow(this);

	m_listView = ((wxListCtrl *)FindWindow(IDC_LIST_PUB));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_PUB_SMALL));
	m_imageListSmall->Add( ico );

	m_listView->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);
	
	m_listView->InsertColumn(0, _("Name"), wxLIST_ALIGN_DEFAULT, 100);
	m_listView->InsertColumn(1, _("Type"), wxLIST_ALIGN_DEFAULT, 60);
	m_listView->InsertColumn(2, _("Path"), wxLIST_ALIGN_DEFAULT, 190);


	if(!Init(ENTITY_TYPE_PUBLICATION))
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();	
}

DlgConfigurePub::~DlgConfigurePub()
{
	if(m_listView) m_listView->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

bool DlgConfigurePub::DisplayConf()
{
	size_t i;

	for(i=0; i<m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications().size(); i++)
	{
		((wxComboBox *)FindWindow(IDC_CA))->Append(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[i].get_caname().c_str(), (void*)i);
	}
	((wxComboBox *)FindWindow(IDC_CA))->SetSelection(0);
	wxCommandEvent event;
	OnCaChanged(event);
	wxString port;

	((wxCheckBox*)FindWindow(IDC_ENABLE_OCSP))->SetValue(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_ocspenabled()?true:false);
	((wxTextCtrl*)FindWindow(IDC_BIND))->SetValue(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_bindaddress().c_str());
	port.sprintf("%ld", m_EntityConf.get_pubConf().PUB_CONF_PTR.get_port());
	((wxTextCtrl*)FindWindow(IDC_PORT))->SetValue(port);

	OnActivateClick(event);

	return true;
}


bool DlgConfigurePub::SetConf()
{
	wxString w_port;
	int port;

	if(((wxCheckBox*)FindWindow(IDC_ENABLE_OCSP))->GetValue())
	{
		m_EntityConf.get_pubConf().PUB_CONF_PTR.set_ocspenabled(1);
		w_port = ((wxTextCtrl*)FindWindow(IDC_PORT))->GetValue();
		if(!w_port.Len())
		{
			return false;
		}
		sscanf(w_port.GetData(), "%d", &port);
		m_EntityConf.get_pubConf().PUB_CONF_PTR.set_port(port);

		w_port = ((wxTextCtrl*)FindWindow(IDC_BIND))->GetValue();
		m_EntityConf.get_pubConf().PUB_CONF_PTR.set_bindaddress(w_port.GetData());
	}
	else
	{
		m_EntityConf.get_pubConf().PUB_CONF_PTR.set_ocspenabled(0);
	}

	return true;
}

void DlgConfigurePub::OnActivateClick(wxCommandEvent &event)
{
	if(((wxCheckBox*)FindWindow(IDC_ENABLE_OCSP))->GetValue())
	{
		((wxTextCtrl*)FindWindow(IDC_BIND))->Enable(TRUE);
		((wxTextCtrl*)FindWindow(IDC_PORT))->Enable(TRUE);
	}
	else
	{
		((wxTextCtrl*)FindWindow(IDC_BIND))->Enable(FALSE);
		((wxTextCtrl*)FindWindow(IDC_PORT))->Enable(FALSE);
	}

}

void DlgConfigurePub::OnCaChanged(wxCommandEvent &event)
{
	size_t i;
	size_t index;
	int SelectedItem;
	const char * Type;
	
	
	SelectedItem = ((wxComboBox *)FindWindow(IDC_CA))->GetSelection();
	if(SelectedItem == -1) return;
	index = (size_t)((wxComboBox *)FindWindow(IDC_CA))->GetClientData(SelectedItem);

	m_listView->DeleteAllItems();


	for(i=0; i<m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods().size(); i++)
	{
		switch(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods()[i].get_type())
		{
			case PUBLICATION_METHOD_INFO_TYPE_CERT:
				Type = _("Certificate");
				break;
			case PUBLICATION_METHOD_INFO_TYPE_CRL:
				Type = _("CRL");
				break;
			default:
				Type = _("Certificate");
		}

		m_listView->InsertItem(i, m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods()[i].get_name().c_str(), 0);
		m_listView->SetItemData(i, (long)i);
		m_listView->SetItem(i, 1, Type);
		m_listView->SetItem(i, 2, m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods()[i].get_librarypath().c_str());
	}
}

void DlgConfigurePub::OnAdd(wxCommandEvent &event)
{
	int SelectedItem;
	PublicationMethodInfo newMethod;
	size_t i, index;

	
	
 	SelectedItem = ((wxComboBox *)FindWindow(IDC_CA))->GetSelection();
	if(SelectedItem == -1) return;
	index = (size_t)((wxComboBox *)FindWindow(IDC_CA))->GetClientData(SelectedItem);
	

	DlgAddPubMeth Dlg(this, PublicationMethodInfo::EmptyInstance);
	if(!Dlg.IsOK())
		return;
	newMethod = Dlg.GetPublication();

	// Does this method already exists ?
	for(i=0; i<m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods().size(); i++)
	{
		if(newMethod.get_name() == m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods()[i].get_name())
			return;
	}
	m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[index].get_methods().push_back(newMethod);
	OnCaChanged(event);
}

void DlgConfigurePub::OnDel(wxCommandEvent &event)
{
	size_t p_index, m_index;
	int SelectedItem;
	
 	SelectedItem = ((wxComboBox *)FindWindow(IDC_CA))->GetSelection();
	if(SelectedItem == -1) return;
	p_index = (size_t)((wxComboBox *)FindWindow(IDC_CA))->GetClientData(SelectedItem);
	
	SelectedItem = m_listView->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	m_index = (size_t)m_listView->GetItemData(SelectedItem);


	// Delete entry
	m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods().erase(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods().begin() + m_index);
	OnCaChanged(event);
}

void DlgConfigurePub::OnMod(wxCommandEvent &event)
{
	size_t i, p_index, m_index;
	int SelectedItem;
	PublicationMethodInfo newEntry;

 	SelectedItem = ((wxComboBox *)FindWindow(IDC_CA))->GetSelection();
	if(SelectedItem == -1) return;
	p_index = (size_t)((wxComboBox *)FindWindow(IDC_CA))->GetClientData(SelectedItem);
	
	SelectedItem = m_listView->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	m_index = (size_t)m_listView->GetItemData(SelectedItem);
	
	DlgAddPubMeth Dlg(this, m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods()[m_index]);
	if(!Dlg.IsOK())
		return;

	newEntry = Dlg.GetPublication();



	// Does this method already exists ?
	for(i=0; i<m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods().size(); i++)
	{
		if(i == m_index)
			continue;
		if(m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods()[i].get_name() == newEntry.get_name())
			return;
	}

	m_EntityConf.get_pubConf().PUB_CONF_PTR.get_publications()[p_index].get_methods()[m_index] = newEntry;
	OnCaChanged(event);
}

