/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigureRep.cpp: implementation of the DlgConfigureRep class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgConfigureRep.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgConfigureRep, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigureEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
END_EVENT_TABLE()


DlgConfigureRep::DlgConfigureRep(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):DlgConfigureEntity(wParent, entity_cert, ClientPki)
{
	DlgConfigureRep_SetWindow(this);
	
	if(!Init(ENTITY_TYPE_REPOSITORY))
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();		
}

DlgConfigureRep::~DlgConfigureRep()
{
}

bool DlgConfigureRep::DisplayConf()
{
	return true;
}


bool DlgConfigureRep::SetConf()
{
	return true;
}
