/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgPkiAdmin.h: interface for the DlgPkiAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGPKIADMIN_H
#define DLGPKIADMIN_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/listctrl.h>
#include <wx/dialog.h>


#include <PkiClient.h>
#include "DlgGUI.h"

#include "DlgMessage.h"




class DlgPkiAdminListCtrl: public wxListCtrl
{
public:
	~DlgPkiAdminListCtrl();
    DlgPkiAdminListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos, const wxSize& size, long style);
    void OnItemRightClick(wxListEvent& event);
    void OnItemClick(wxListEvent& event);
private:
    DECLARE_EVENT_TABLE()
};




class DlgPkiAdmin: public DlgGUI
{
public:
	DlgPkiAdmin(wxWindow * wParent, char * EntityName, char * UserName, char * Password, PkiClient * ClientPki);
	virtual ~DlgPkiAdmin();

	void OnManageEntityACL(wxCommandEvent& event);
	void OnManageEntityMailConf(wxCommandEvent& event);
	void OnManageEntityAudits(wxCommandEvent& event);
	void OnSendAdminMail(wxCommandEvent& event);

	void OnManageGroups(wxCommandEvent& event);
	void OnManageEntities(wxCommandEvent& event);
	void OnManageRepInfo(wxCommandEvent& event);
	void OnExportConf(wxCommandEvent& event);
	void OnSetOffline(wxCommandEvent& event);
	void OnConfigureEntity(wxCommandEvent& event);
	void OnRevokeEntity(wxCommandEvent& event);
	void OnManageUsers(wxCommandEvent& event);
	void OnImportReq(wxCommandEvent& event);
	void OnItemRightClick(wxListEvent& event);
	void OnItemClick(wxListEvent& event);
	void OnReload(wxCommandEvent& event);
	void OnShowEntityCert(wxCommandEvent &event);

private:
	const char * GetEmail(const PKI_CERT & Cert);

	int CaIconId;
	int EEIconId;
	int RaIconId;
	int RepositoryIconId;
	int KeyIconId;
	int PublicationIconId;
	int UnknownIconId;

	mVector<EntityEntryInfo> m_entities;

	void OnRightClick(wxListEvent& event);
	bool LoadEntitiesList();
	DlgPkiAdminListCtrl *m_listCtrl;
	bool ReloadConf();
	wxImageList * m_imageListSmall;
	DECLARE_EVENT_TABLE()
};

#endif
