/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgShowLog.cpp: implementation of the DlgShowLog class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgShowLog.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(DlgShowLog, wxDialog)
    EVT_BUTTON(IDC_OK, DlgShowLog::OnOk)
    EVT_BUTTON(IDC_CHECK_SIGNATURE, DlgShowLog::OnCheckSignature)
END_EVENT_TABLE()


DlgShowLog::DlgShowLog(wxWindow * wParent, const LogEntry & Log, const PKI_CERT & CaCert):wxDialog(wParent, (wxWindowID)-1, _("Log properties"), wxDefaultPosition), m_CaCert(CaCert), m_Log(Log)
{
	DlgShowLog_SetWindow(this);

	mString object;


	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetBackgroundColour(GetBackgroundColour());
	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetForegroundColour(*wxRED);
	((wxTextCtrl *)FindWindow(IDC_SIGNATURE))->SetBackgroundColour(GetBackgroundColour());
	((wxTextCtrl *)FindWindow(IDC_USER))->SetBackgroundColour(GetBackgroundColour());
	((wxTextCtrl *)FindWindow(IDC_OBJECT))->SetBackgroundColour(GetBackgroundColour());


	((wxStaticText *)FindWindow(IDC_DATE))->SetLabel(FormatTime(m_Log.get_body().get_logDate()));
	((wxStaticText *)FindWindow(IDC_TYPE))->SetLabel(ASN1_logs_get_TypeString((LOG_MESSAGE_TYPE)m_Log.get_body().get_logType()));
	((wxStaticText *)FindWindow(IDC_STATUS))->SetLabel(ASN1_logs_get_StatusString((LOG_MESSAGE_STATUS)m_Log.get_body().get_logStatus()));
	((wxTextCtrl *)FindWindow(IDC_USER))->SetValue(m_Log.get_body().get_user().c_str());

	if(m_Log.get_body().get_objectName().size())
		object = m_Log.get_body().get_objectName();
	if(!object.size())
		object = _("None");

	((wxTextCtrl *)FindWindow(IDC_OBJECT))->SetValue(object.c_str());
	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetValue(m_Log.get_body().get_error().c_str());

	if(m_Log.get_sig().to_PEM(object)  && object.size())
	{
		((wxTextCtrl *)FindWindow(IDC_SIGNATURE))->SetValue(object.c_str());
		if(!m_CaCert)
			((wxButton *)FindWindow(IDC_CHECK_SIGNATURE))->Enable(FALSE);
	}
	else
	{
		((wxButton *)FindWindow(IDC_CHECK_SIGNATURE))->Enable(FALSE);
	}

	CenterOnScreen();
	ShowModal();
}

DlgShowLog::~DlgShowLog()
{
}

void DlgShowLog::OnOk(wxCommandEvent& event)
{
	Close(TRUE);
}


void DlgShowLog::OnCheckSignature(wxCommandEvent &event)
{
	LOG_ENTRY * log;

	if(!((wxTextCtrl *)FindWindow(IDC_SIGNATURE))->GetValue().Len()) return;

	log = NULL;
	if(!m_Log.give_Datas(&log))
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	if(!LOG_ENTRY_verify(log, (EVP_PKEY *)m_CaCert.GetPublicKey()))
	{
		DisplayMessage(this, _("The log signature is invalid"), wxOK | wxICON_ERROR);
	}
	else
	{
		DisplayMessage(this, _("The log signature is valid"), wxOK);
	}
	ASN1_item_free((ASN1_VALUE*)log, LogEntry::get_ASN1_ITEM());
}
