/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef FILELOG_H
#define FILELOG_H

#include <stdlib.h>
#include <stdio.h>
#include <mString.h>
#include <stdarg.h>
#include <time.h>
#include "NewPKI.h"

#define OCSP_LOG "OCSP responder"		//!< The prefix added to the logs for an OCSP log entry
#define PKI_LOG "PKI server"			//!< The prefix added to the logs for an PKI log entry
#define SOCKET_LOG "SOCKET server"		//!< The prefix added to the logs for an SOCKET log entry

/*!
  This enumeration defines the debuging logs level
*/
typedef enum en_LOG_LEVEL
{
	LOG_LEVEL_NONE=0,		//!< User wants no debuging logs at all
	LOG_LEVEL_ERROR=1,		//!< User wants only ERROR debuging logs type
	LOG_LEVEL_WARNING=2,	//!< User wants only ERROR and WARNING debuging logs type
	LOG_LEVEL_INFO=3,		//!< User wants only ERROR, WARNING and INFO debuging logs type
	LOG_LEVEL_DEBUG=4		//!< User wants only ERROR, WARNING, INFO and DEBUG debuging logs type
}LOG_LEVEL;

/*! \brief The function sets the destination log file.
 *  \param File [IN] The path to the log file.
 *  \param level [IN] The level.
 *  \return true on success, false on failure.
 */
bool InitFileLog(const char * File, LOG_LEVEL level);

/*! \brief The function must be called before program termination.
 */
void CleanFileLog();


/*! \brief The function writes to the log file.
 *  \param prog [IN] The log prefix.
 *  \param pattern [IN] Like printf.
 *  \param ... [IN] a list of variables.
 */
void LogInFile(const char * prog, const char * pattern, ...);

/*! \brief The function writes a delimiter between two runs.
 *  \param Delimiter [IN] The delimiter to insert.
 */
void LogInsertDelimiter(const char * Delimiter);

/*! \brief The function writes a debugging info to the log file.
 *  \param level [IN] The level of the debugging info.
 *  \param prog [IN] The debugging log prefix.
 *  \param pattern [IN] Like printf.
 *  \param ... [IN] a list of variables.
 */
void NewpkiDebug(LOG_LEVEL level, const char * prog, const char * pattern, ...);

/*! \brief The function returns the debug level.
 *  \return The debug level.
 */
LOG_LEVEL GetDebugLevel();

#endif //FILELOG_H
