/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// StringHashTable_String.cpp: implementation of the StringHashTable_String class.
//
//////////////////////////////////////////////////////////////////////

#include "HashTable_String.h"
#include <PKI_ERR.h>




HashTable_String::HashTable_String()
{
}


HashTable_String::~HashTable_String()
{
	Clear();
}


const char * HashTable_String::Get(const char * Name) const
{
	return (const char *)m_Get(Name);
}


const char * HashTable_String::Get(long Pos) const
{
	return (const char *)m_GetPTR(Pos);
}


bool HashTable_String::Add(const char *Name, const char *Value)
{
	return m_Add(Name, Value, strlen(Value)+1);
}


bool HashTable_String::Modify(const char *Name, const char *Value)
{
	return m_Modify(Name, Value, strlen(Value)+1);
}


bool HashTable_String::operator =(const HashTable_String &other)
{
	return PKI_HashTable::operator=(other);
}

bool HashTable_String::From_EXTENSION_VALUE(const mVector<ExtensionValue> & Exts)
{
	Clear();
	size_t i;
	
	AllowDuplicateNames();
	for(i=0; i<Exts.size(); i++)
	{
		if(!Exts[i].get_name().size()) continue;
		Add(Exts[i].get_name().c_str(), Exts[i].get_value().c_str());
	}

	return true;
}

bool HashTable_String::To_EXTENSION_VALUE(mVector<ExtensionValue> & Exts)
{
	long i;
	const char * value;
	const char * name;

	Exts.clear();

	for(i=0; i<EntriesCount(); i++)
	{
		name = GetName(i);
		value = Get(i);
		if(!name || !value) continue;

		Exts.insert(Exts.begin() + i);
		Exts[i].set_name(name);
		Exts[i].set_value(value);
	}

	return true;
}

bool HashTable_String::From_PLUG_OPTION(const mVector<PlugOption> & Options)
{
	Clear();
	size_t i;
	
	AllowDuplicateNames();
	for(i=0; i<Options.size(); i++)
	{
		if(!Options[i].get_name().size()) continue;
		Add(Options[i].get_name().c_str(), Options[i].get_value().c_str());
	}

	return true;
}

bool HashTable_String::To_PLUG_OPTION(mVector<PlugOption> & Options)
{
	long i;
	const char * value;
	const char * name;

	Options.clear();

	for(i=0; i<EntriesCount(); i++)
	{
		name = GetName(i);
		value = Get(i);
		if(!name || !value) continue;

		Options.insert(Options.begin() + i);
		Options[i].set_name(name);
		Options[i].set_value(value);
	}

	return true;
}

bool HashTable_String::From_POLICY_VALUE(const mVector<PolicyValue> & Policies)
{
	Clear();
	size_t i;
	
	AllowDuplicateNames();
	for(i=0; i<Policies.size(); i++)
	{
		if(!Policies[i].get_name().size()) continue;
		Add(Policies[i].get_name().c_str(), Policies[i].get_value().c_str());
	}
	return true;
}

bool HashTable_String::To_POLICY_VALUE(mVector<PolicyValue> & Policies)
{
	long i;
	const char * value;
	const char * name;

	Policies.clear();

	for(i=0; i<EntriesCount(); i++)
	{
		name = GetName(i);
		value = Get(i);
		if(!name || !value) continue;

		Policies.insert(Policies.begin() + i);
		Policies[i].set_name(name);
		Policies[i].set_value(value);
	}

	return true;
}


DN_TYPE HashTable_String::IsValidPolicyField(const mString & Name, const mString & Value)
{
	int k;
	static char * DN_TYPE_VALUE[NUM_DN_TYPE] = {STR_OPTIONAL, STR_SUPPLIED, STR_MATCH};

	if(!Name.size() || !Value.size())
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_PARAM);
		ERR_add_error_data(1, "(null)");
		return DN_TYPE_UNKNOWN;
	}

	if(!IsValidObject(Name))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN_NID);
		ERR_add_error_data(1, Name.c_str());
		return DN_TYPE_UNKNOWN;
	}		
	
	
	//On vrifie que le champ ait une bonne valeur
	for(k=0; k<NUM_DN_TYPE; k++)
	{
		if(strncmp(Value.c_str(), DN_TYPE_VALUE[k], strlen(DN_TYPE_VALUE[k]))==0)
		{
			return (DN_TYPE)k;
		}
	}

	NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS_FORMAT);
	ERR_add_error_data(1, Name.c_str());
	return DN_TYPE_UNKNOWN;
}
