/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// MailInfo.cpp: implementation of the MailInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "MailInfo.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MailInfo::MailInfo()
{
	m_SignMail = false;
}

MailInfo::~MailInfo()
{
}

void MailInfo::set_MailTo(const mString & MailTo)
{
	m_MailTo = MailTo;
}

const mString & MailInfo::get_MailTo() const
{
	return m_MailTo;
}

void MailInfo::set_AttachName(const mString & AttachName)
{
	m_AttachName = AttachName;
}

const mString & MailInfo::get_AttachName() const
{
	return m_AttachName;
}

void MailInfo::set_SignMail(bool SignMail)
{
	m_SignMail = SignMail;
}

bool MailInfo::get_SignMail() const
{
	return m_SignMail;
}

void MailInfo::set_Body(const mString & Body)
{
	m_Body = Body;
}

const mString & MailInfo::get_Body() const
{
	return m_Body;
}

void MailInfo::set_Subject(const mString & Subject)
{
	m_Subject = Subject;
}

const mString & MailInfo::get_Subject() const
{
	return m_Subject;
}

void MailInfo::set_AttachType(const mString & AttachType)
{
	m_AttachType = AttachType;
}

const mString & MailInfo::get_AttachType() const
{
	return m_AttachType;
}

const mBuffer & MailInfo::c_get_Attach() const
{
	return m_Attach;
}

mBuffer & MailInfo::get_Attach()
{
	return m_Attach;
}

MailInfo::operator int() const
{
	if(!m_Subject.size() || !m_Body.size())
		return 0;
	else
		return 1;
}

bool MailInfo::FromMAIL_DATAS(const MailDatas & mail)
{
	Clear();
	m_Body = mail.get_body();
	m_Subject = mail.get_subject();
	m_SignMail = (mail.get_signmail() != 0);
	m_AttachName = mail.get_attachname();
	m_AttachType = mail.get_attachtype();

	if(mail.get_attach().get_Buffer() && mail.get_attach().get_BufferLen())
	{
		if(!m_Attach.Copy(mail.get_attach().get_Buffer(), mail.get_attach().get_BufferLen()))
		{
			NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}

	return true;
}

void MailInfo::Clear()
{
	m_Attach.Clear();
	m_AttachName = "";
	m_AttachType = "";
	m_MailTo = "";
	m_Body = "";
	m_Subject = "";
	m_SignMail = false;
}
