/* $Id: nntp.c,v 1.3 1995/10/02 01:37:04 chris Exp $ */

/* $Log */

/* NNTP part of newsflash; uses tcp.c to connect to the nntpserver */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "nntp.h"
#include "tcp.h"
#include "sizes.h"
#include "newsflash.h"


static char rcsid[]="$Id: nntp.c,v 1.3 1995/10/02 01:37:04 chris Exp $";


#define BUFFERSIZE 2048  /* make this at least your MTU */


static char sname[LONGSTRING];


char *strip_crlf(char *s)
{
  char *t;
  
  t=s;
  while (*t) {
    if (*t=='\r'||*t=='\n') {
      *t=0;
      break;
    }
    t++;
  }
  return s;
}
 

void output(char *what)
{
  /* printf("%s",what); */
}

FILE *nntp_connect_to_server(char *servername)
{
  char line[LONGSTRING];
  int x;
  FILE *socket;

  if (verbosity>=1) printf("Opening connection to %s...\n",servername);
  strcpy(sname,servername);
  socket=tcp_open_connection(servername,"nntp");
  if (!socket) {
    printf("%s: host is unreachable\n",servername);
    return NULL;
  }
  x=tcp_read_line(socket,line,LONGSTRING,TIMEOUT);
  if (x) {
    sscanf(line,"%d",&x);
    output(line);
  }
  if (!x||(x!=200&&x!=201)) {
    tcp_close_connection(socket);
    if (x) printf("%s does not welcome us, %s\n", servername, strip_crlf(line));
    else printf("%s closed connection immediately\n", servername);
    return NULL;
  }
  if (verbosity>=3) printf("%s: connection opened, server welcomed us\n",servername);
  return socket;
}


int nntp_send_command(FILE *socket, char *command)
{
  char line[LONGSTRING];
  int x;

  fputs(command,socket);
  fflush(socket);
#ifdef DEBUG
  printf(">%s",command);
#endif
  x=tcp_read_line(socket,line,sizeof(line), TIMEOUT);
  if (x) {
    sscanf(line,"%d",&x);
    output(line);
  }
  return x;
}


int nntp_close_connection(FILE *socket)
{
  int x;
  
  x=nntp_send_command(socket,"quit\r\n");
  if (!x||x!=205) {
    if (verbosity>=3) printf("%s does not understand QUIT??? oh well...",sname);
  }
  tcp_close_connection(socket);
  return 0;
}


int nntp_send_ihave(FILE *socket,char *mid)
{
  char buf[LONGSTRING];
  int x;
  
  sprintf(buf,"IHAVE %s\r\n",mid);
  x=nntp_send_command(socket,buf);
  if (!x||x!=335) return 0;	/* don't send */
  else return 1;
}


void nntp_send_line(FILE *socket, char *line)
{
  char buf[VERYLONGSTRING];
  char *s,*t;

  for (s=line,t=buf; *s; s++,t++) {
    if (*s&&*s!='\r'&&*s!='\n') *t=*s;
    else if (*s=='\r'||*s=='\n') {
      *t++='\r';
      *t++='\n';
      *t='\0';
      break;
    }
    else {
      *t='\0';
      break;
    }
  }
  fputs(buf,socket);
  fflush(socket);
  output(buf);
}


int nntp_end_of_article(FILE *socket)
{
  int x;
  
  x=nntp_send_command(socket,"\r\n.\r\n");
  if (!x||x!=235) {
    return 1; /* not transferred successfully */
  }
  else return 0;
}

