/*
 *  This file is part of the nfdump project.
 *
 *  Copyright (c) 2008, SWITCH - Teleinformatikdienste fuer Lehre und Forschung
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions are met:
 *  
 *   * Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the documentation 
 *     and/or other materials provided with the distribution.
 *   * Neither the name of SWITCH nor the names of its contributors may be 
 *     used to endorse or promote products derived from this software without 
 *     specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 *  POSSIBILITY OF SUCH DAMAGE.
 *  
 *  $Author: peter $
 *
 *  $Id: collector.h 100 2008-08-15 11:36:21Z peter $
 *
 *  $LastChangedRevision: 100 $
 *	
 */

#define FNAME_SIZE  256
#define IDENT_SIZE  32

typedef struct srecord_s {
    char    fname[FNAME_SIZE];      // file name
    char    subdir[FNAME_SIZE];     // subdir name
    char    tstring[16];            // actually 12 needed e.g. 200411011230
    time_t  tstamp;                 // UNIX time stamp
	int		failed;					// in case of an error
} srecord_t;

// common_record_t defines ext_map as uint_8, so max 256 extension maps allowed.
// should be enough anyway


typedef struct FlowSource_s {
	// link
	struct FlowSource_s *next;

	// exporter identifiers
	char 				Ident[IdentLen];
	uint64_t			ip[2];

	int					any_source;
	bookkeeper_t 		*bookkeeper;

	// all about data storage
	char				*datadir;		// where to store data for this source
	char				*current;		// current file name - typically nfcad.current.pid
	nffile_t			nffile;			// the writing file handle

	// statistical data per source
	stat_record_t		stat_record;
	uint32_t			bad_packets;
	uint64_t			first_seen;
	uint64_t			last_seen;

	// Any exporter specific data
	void				*exporter_data;

	// extension map list
	struct {
#define MAP_BLOCKSIZE	16
		int	next_free;
		int	max_maps;
		extension_map_t	**maps;
	} extension_map_list;


} FlowSource_t;

// prototypes
int AddFlowSource(FlowSource_t **FlowSource, char *ident);

int AddDefaultFlowSource(FlowSource_t **FlowSource, char *ident, char *path);

int InitExtensionMapList(FlowSource_t *fs);

int AddExtensionMap(FlowSource_t *fs, extension_map_t *map);

void FlushExtensionMaps(FlowSource_t *fs);

void launcher (char *commbuff, FlowSource_t *FlowSource, char *process, int expire);

/* default path to store data - not really attractive, but anyway ... */
#define DEFAULT_DIR	  	"/var/tmp"

/* Default time window in seconds to rotate files */
#define TIME_WINDOW	  	300

/* overdue time: 
 * if nfcapd does not get any data, wake up the receive system call
 * at least after OVERDUE_TIME seconds after the time window
 */
#define OVERDUE_TIME	10

// time nfcapd will wait for launcher to terminate
#define LAUNCHER_TIMEOUT 60

#define SYSLOG_FACILITY LOG_DAEMON

