/* cleanutmp.c
   chown root.utmp cleanutmp
   chmod 2711 cleanutmp
 */

#include <utmp.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include "lib.h"

void ops(int n, const char *s0, const char *s1) {
  write(2,s0,str_len(s0));
  write(2,s1,str_len(s1));
  write(2,"\n",1);
  _exit(n);
}

int main() {
  int fd,wfd;
  struct utmp ut;
  off_t pos=0;

  if ((fd = open(_PATH_UTMP,O_RDWR)) <0 &&
      (fd = open(_PATH_UTMP,O_RDONLY)) <0)
    ops(1,"error opening: ", _PATH_UTMP);

  while (utmp_io(fd,&ut,F_RDLCK)) {
    pos += UTMP_SIZE;
    if (ut.ut_type != USER_PROCESS) continue;
    if (kill(ut.ut_pid, 0) && errno == ESRCH) {
      ut.ut_type = DEAD_PROCESS;
      ut.ut_tv.tv_sec = time(0);

      pos -= UTMP_SIZE;
      if (lseek(fd, pos, SEEK_SET) != pos || 
	  !utmp_io(fd,&ut,F_WRLCK))
	ops(2,"error writing to: ", _PATH_UTMP);
      pos += UTMP_SIZE;
      
      wfd=open(_PATH_WTMP, O_WRONLY|O_APPEND);
      if (wfd>=0) {
	write(fd, &ut, UTMP_SIZE);
	close(wfd);
      }
    }
  }
  close(fd);
  return 0;
}
