# 1 "Int.hs.cpp"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "Int.hs.cpp"
module NHC.FFI
  -- all types are abstract and instances of:
  -- Num, Bounded, Real, Integral, Ix, Enum, Read, Show
  ( Int8
  , Int16
  , Int32
  , Int64
  ) where

{- Note explicit braces and semicolons here - layout is corrupted by cpp. -}

{import Numeric (readSigned,readDec,showSigned,showInt)
;import Ix
# 121 "Int.hs.cpp"
; ; data Int8 ; ; foreign import ccall primEqInt8 :: Int8 -> Int8 -> Bool ; foreign import ccall primLtInt8 :: Int8 -> Int8 -> Bool ; foreign import ccall primLeInt8 :: Int8 -> Int8 -> Bool ; foreign import ccall primGtInt8 :: Int8 -> Int8 -> Bool ; foreign import ccall primGeInt8 :: Int8 -> Int8 -> Bool ; foreign import ccall primAddInt8 :: Int8 -> Int8 -> Int8 ; foreign import ccall primSubInt8 :: Int8 -> Int8 -> Int8 ; foreign import ccall primMulInt8 :: Int8 -> Int8 -> Int8 ; foreign import ccall primAbsInt8 :: Int8 -> Int8 ; foreign import ccall primSignumInt8 :: Int8 -> Int8 ; foreign import ccall primQuotInt8 :: Int8 -> Int8 -> Int8 ; foreign import ccall primRemInt8 :: Int8 -> Int8 -> Int8 ; foreign import ccall primToEnumInt8 :: Int -> Int8 ; foreign import ccall primFromEnumInt8 :: Int8 -> Int ; foreign import ccall primInt8FromInteger :: Integer -> Int8 ; foreign import ccall primInt8ToInteger :: Int8 -> Integer ; ; instance Eq Int8 where { (==) = primEqInt8 } ; ; instance Ord Int8 where { (<) = primLtInt8 ; (<=) = primLeInt8 ; (>) = primGtInt8 ; (>=) = primGeInt8 } ; ; instance Num Int8 where { (+) = primAddInt8 ; (-) = primSubInt8 ; (*) = primMulInt8 ; abs = primAbsInt8 ; signum = primSignumInt8 ; fromInteger = primInt8FromInteger } ; ; instance Bounded Int8 where { minBound = fromInteger (-128) ; maxBound = fromInteger 127 } ; ; instance Real Int8 where { toRational i = toInteger i % 1 } ; ; instance Integral Int8 where { quot = primQuotInt8 ; rem = primRemInt8 ; toInteger = primInt8ToInteger } ; ; instance Ix Int8 where { range (m,n) = [m..n] ; index b@(m,n) i | inRange b i = fromIntegral (i-m) | True = error "Ix.index: Index out of range." ; inRange (m,n) i = m <= i && i <= n } ; ; instance Enum Int8 where { toEnum = primToEnumInt8 ; fromEnum = primFromEnumInt8 ; enumFrom n = n : enumFrom (n+1) ; enumFromThen m n = m : enumFromThen n (2*n-m) } ; ; instance Read Int8 where { readsPrec p = readSigned readDec } ; ; instance Show Int8 where { showsPrec p = showSigned showInt p }
; ; data Int16 ; ; foreign import ccall primEqInt16 :: Int16 -> Int16 -> Bool ; foreign import ccall primLtInt16 :: Int16 -> Int16 -> Bool ; foreign import ccall primLeInt16 :: Int16 -> Int16 -> Bool ; foreign import ccall primGtInt16 :: Int16 -> Int16 -> Bool ; foreign import ccall primGeInt16 :: Int16 -> Int16 -> Bool ; foreign import ccall primAddInt16 :: Int16 -> Int16 -> Int16 ; foreign import ccall primSubInt16 :: Int16 -> Int16 -> Int16 ; foreign import ccall primMulInt16 :: Int16 -> Int16 -> Int16 ; foreign import ccall primAbsInt16 :: Int16 -> Int16 ; foreign import ccall primSignumInt16 :: Int16 -> Int16 ; foreign import ccall primQuotInt16 :: Int16 -> Int16 -> Int16 ; foreign import ccall primRemInt16 :: Int16 -> Int16 -> Int16 ; foreign import ccall primToEnumInt16 :: Int -> Int16 ; foreign import ccall primFromEnumInt16 :: Int16 -> Int ; foreign import ccall primInt16FromInteger :: Integer -> Int16 ; foreign import ccall primInt16ToInteger :: Int16 -> Integer ; ; instance Eq Int16 where { (==) = primEqInt16 } ; ; instance Ord Int16 where { (<) = primLtInt16 ; (<=) = primLeInt16 ; (>) = primGtInt16 ; (>=) = primGeInt16 } ; ; instance Num Int16 where { (+) = primAddInt16 ; (-) = primSubInt16 ; (*) = primMulInt16 ; abs = primAbsInt16 ; signum = primSignumInt16 ; fromInteger = primInt16FromInteger } ; ; instance Bounded Int16 where { minBound = fromInteger (-32768) ; maxBound = fromInteger 32767 } ; ; instance Real Int16 where { toRational i = toInteger i % 1 } ; ; instance Integral Int16 where { quot = primQuotInt16 ; rem = primRemInt16 ; toInteger = primInt16ToInteger } ; ; instance Ix Int16 where { range (m,n) = [m..n] ; index b@(m,n) i | inRange b i = fromIntegral (i-m) | True = error "Ix.index: Index out of range." ; inRange (m,n) i = m <= i && i <= n } ; ; instance Enum Int16 where { toEnum = primToEnumInt16 ; fromEnum = primFromEnumInt16 ; enumFrom n = n : enumFrom (n+1) ; enumFromThen m n = m : enumFromThen n (2*n-m) } ; ; instance Read Int16 where { readsPrec p = readSigned readDec } ; ; instance Show Int16 where { showsPrec p = showSigned showInt p }
; ; data Int32 ; ; foreign import ccall primEqInt32 :: Int32 -> Int32 -> Bool ; foreign import ccall primLtInt32 :: Int32 -> Int32 -> Bool ; foreign import ccall primLeInt32 :: Int32 -> Int32 -> Bool ; foreign import ccall primGtInt32 :: Int32 -> Int32 -> Bool ; foreign import ccall primGeInt32 :: Int32 -> Int32 -> Bool ; foreign import ccall primAddInt32 :: Int32 -> Int32 -> Int32 ; foreign import ccall primSubInt32 :: Int32 -> Int32 -> Int32 ; foreign import ccall primMulInt32 :: Int32 -> Int32 -> Int32 ; foreign import ccall primAbsInt32 :: Int32 -> Int32 ; foreign import ccall primSignumInt32 :: Int32 -> Int32 ; foreign import ccall primQuotInt32 :: Int32 -> Int32 -> Int32 ; foreign import ccall primRemInt32 :: Int32 -> Int32 -> Int32 ; foreign import ccall primToEnumInt32 :: Int -> Int32 ; foreign import ccall primFromEnumInt32 :: Int32 -> Int ; foreign import ccall primInt32FromInteger :: Integer -> Int32 ; foreign import ccall primInt32ToInteger :: Int32 -> Integer ; ; instance Eq Int32 where { (==) = primEqInt32 } ; ; instance Ord Int32 where { (<) = primLtInt32 ; (<=) = primLeInt32 ; (>) = primGtInt32 ; (>=) = primGeInt32 } ; ; instance Num Int32 where { (+) = primAddInt32 ; (-) = primSubInt32 ; (*) = primMulInt32 ; abs = primAbsInt32 ; signum = primSignumInt32 ; fromInteger = primInt32FromInteger } ; ; instance Bounded Int32 where { minBound = fromInteger (-2147483648) ; maxBound = fromInteger 2147483647 } ; ; instance Real Int32 where { toRational i = toInteger i % 1 } ; ; instance Integral Int32 where { quot = primQuotInt32 ; rem = primRemInt32 ; toInteger = primInt32ToInteger } ; ; instance Ix Int32 where { range (m,n) = [m..n] ; index b@(m,n) i | inRange b i = fromIntegral (i-m) | True = error "Ix.index: Index out of range." ; inRange (m,n) i = m <= i && i <= n } ; ; instance Enum Int32 where { toEnum = primToEnumInt32 ; fromEnum = primFromEnumInt32 ; enumFrom n = n : enumFrom (n+1) ; enumFromThen m n = m : enumFromThen n (2*n-m) } ; ; instance Read Int32 where { readsPrec p = readSigned readDec } ; ; instance Show Int32 where { showsPrec p = showSigned showInt p }
; ; data Int64 ; ; foreign import ccall primEqInt64 :: Int64 -> Int64 -> Bool ; foreign import ccall primLtInt64 :: Int64 -> Int64 -> Bool ; foreign import ccall primLeInt64 :: Int64 -> Int64 -> Bool ; foreign import ccall primGtInt64 :: Int64 -> Int64 -> Bool ; foreign import ccall primGeInt64 :: Int64 -> Int64 -> Bool ; foreign import ccall primAddInt64 :: Int64 -> Int64 -> Int64 ; foreign import ccall primSubInt64 :: Int64 -> Int64 -> Int64 ; foreign import ccall primMulInt64 :: Int64 -> Int64 -> Int64 ; foreign import ccall primAbsInt64 :: Int64 -> Int64 ; foreign import ccall primSignumInt64 :: Int64 -> Int64 ; foreign import ccall primQuotInt64 :: Int64 -> Int64 -> Int64 ; foreign import ccall primRemInt64 :: Int64 -> Int64 -> Int64 ; foreign import ccall primToEnumInt64 :: Int -> Int64 ; foreign import ccall primFromEnumInt64 :: Int64 -> Int ; foreign import ccall primInt64FromInteger :: Integer -> Int64 ; foreign import ccall primInt64ToInteger :: Int64 -> Integer ; ; instance Eq Int64 where { (==) = primEqInt64 } ; ; instance Ord Int64 where { (<) = primLtInt64 ; (<=) = primLeInt64 ; (>) = primGtInt64 ; (>=) = primGeInt64 } ; ; instance Num Int64 where { (+) = primAddInt64 ; (-) = primSubInt64 ; (*) = primMulInt64 ; abs = primAbsInt64 ; signum = primSignumInt64 ; fromInteger = primInt64FromInteger } ; ; instance Bounded Int64 where { minBound = fromInteger (-9223372036854775808) ; maxBound = fromInteger 9223372036854775807 } ; ; instance Real Int64 where { toRational i = toInteger i % 1 } ; ; instance Integral Int64 where { quot = primQuotInt64 ; rem = primRemInt64 ; toInteger = primInt64ToInteger } ; ; instance Ix Int64 where { range (m,n) = [m..n] ; index b@(m,n) i | inRange b i = fromIntegral (i-m) | True = error "Ix.index: Index out of range." ; inRange (m,n) i = m <= i && i <= n } ; ; instance Enum Int64 where { toEnum = primToEnumInt64 ; fromEnum = primFromEnumInt64 ; enumFrom n = n : enumFrom (n+1) ; enumFromThen m n = m : enumFromThen n (2*n-m) } ; ; instance Read Int64 where { readsPrec p = readSigned readDec } ; ; instance Show Int64 where { showsPrec p = showSigned showInt p }

}
