/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LetExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class FluidLetExp
extends LetExp {
    static ClassType typeFuture = ClassType.make("gnu.mapping.Future");
    static Method getContextMethod = typeFuture.addMethod("getContext", Type.typeArray0, typeFuture, 9);
    public static ClassType typeFluidBinding = ClassType.make("gnu.mapping.FluidBinding");
    static Field fluidBindingsField = typeFuture.addField("fluidBindings", typeFluidBinding, 9);
    public static Field valueField = typeFluidBinding.addField("value", Type.pointer_type, 1);
    static Method setFluidsMethod;
    static Method resetFluidsMethod;
    static Method makeFluidBindingMethod;

    public FluidLetExp(Expression[] i) {
        super(i);
    }

    public void compile(Compilation comp, Target target) {
        Type result_type;
        CodeAttr code = comp.getCode();
        code.pushScope();
        Type type = result_type = target instanceof IgnoreTarget ? null : this.getType();
        Target ttarg = result_type == null ? Target.Ignore : (result_type == Type.pointer_type ? Target.pushObject : new StackTarget(result_type));
        Variable future = code.addLocal(typeFuture);
        code.emitInvokeStatic(getContextMethod);
        code.emitDup(1);
        code.emitStore(future);
        code.emitDup(1);
        code.emitGetField(fluidBindingsField);
        Variable old_bindings = code.addLocal(typeFluidBinding);
        code.emitDup(1);
        code.emitStore(old_bindings);
        code.enterScope(this.scope);
        Declaration decl = this.firstDecl();
        int i = 0;
        while (i < this.inits.length) {
            decl.allocateVariable(code);
            this.inits[i].compile(comp, Target.pushObject);
            decl.base.load(comp);
            code.emitInvokeStatic(makeFluidBindingMethod);
            code.emitDup(1);
            code.emitStore(decl.getVariable());
            ++i;
            decl = decl.nextDecl();
        }
        code.emitInvokeVirtual(setFluidsMethod);
        code.emitTryStart(true, result_type);
        this.body.compileWithPosition(comp, ttarg);
        code.emitTryEnd();
        code.emitFinallyStart();
        code.emitLoad(future);
        code.emitLoad(old_bindings);
        code.emitInvokeVirtual(resetFluidsMethod);
        code.emitTryCatchEnd();
        code.popScope();
        code.popScope();
        if (result_type != null) {
            target.compileFromStack(comp, result_type);
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkFluidLetExp(this);
    }

    static {
        Type[] args = new Type[]{typeFluidBinding};
        setFluidsMethod = typeFuture.addMethod("setFluids", args, Type.void_type, 1);
        resetFluidsMethod = typeFuture.addMethod("resetFluids", args, Type.void_type, 1);
        args = new Type[]{typeFluidBinding, Type.pointer_type, ClassType.make("gnu.mapping.Binding")};
        makeFluidBindingMethod = typeFluidBinding.addMethod("make", args, typeFluidBinding, 9);
    }
}

