/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Map;
import mlsub.typing.Debug;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.NullnessKind;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.UnknownMonotype;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;
import mlsub.typing.lowlevel.Unsatisfiable;

public final class MonotypeVar
extends Monotype
implements Element,
TypeSymbol {
    private String name;
    private int id = -1;
    Kind kind;
    Kind persistentKind;
    private boolean allowUnknown = false;
    private boolean unknown;
    private Monotype equivalent;
    private boolean existential;
    private static int uniqueNum = 0;

    public MonotypeVar() {
    }

    public MonotypeVar(boolean existential) {
        this.existential = existential;
    }

    public MonotypeVar(String name) {
        this.name = name;
    }

    private MonotypeVar(String name, Kind persistentKind) {
        this.name = name;
        this.setPersistentKind(persistentKind);
    }

    public String getName() {
        return this.name;
    }

    public TypeSymbol cloneTypeSymbol() {
        return new MonotypeVar(this.name, this.persistentKind);
    }

    Monotype substitute(Map map2) {
        Object newVar = map2.get(this);
        if (newVar == null) {
            return this;
        }
        return (Monotype)newVar;
    }

    public static MonotypeVar[] news(int n) {
        return MonotypeVar.news(n, false);
    }

    static MonotypeVar[] news(int n, boolean existential) {
        if (n == 0) {
            return null;
        }
        MonotypeVar[] res = new MonotypeVar[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new MonotypeVar(existential);
            res[i].setPersistentKind(NullnessKind.instance);
        }
        return res;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        if (this.kind != null && value != null && this.kind != value) {
            throw new InternalError("Variance already set in MonotypeVar " + this + ":\nkind was " + this.kind + ", value is " + value);
        }
        if (this.kind == value) {
            return;
        }
        this.kind = value;
        if (value == null) {
            this.equivalent = null;
            this.id = -1;
        } else {
            TypeConstructor tc;
            this.equivalent = value.freshMonotype(this.existential);
            if (Typing.dbg) {
                Debug.println("Equivalence: " + this + " == " + this.equivalent);
            }
            if (this.equivalent != null && (tc = this.equivalent.head()) != null) {
                tc.name = this + "'";
            }
        }
    }

    public void resetKind(Kind value) {
        this.setKind(null);
        this.setKind(value);
    }

    public void setPersistentKind(Kind k) {
        if (this.persistentKind == k) {
            return;
        }
        this.persistentKind = k;
        if (k == NullnessKind.instance) {
            this.kind = k;
            this.equivalent = NullnessKind.instance.persistentFreshMonotype(this);
        }
    }

    void reset() {
        this.unknown = false;
        if (this.persistentKind == null) {
            this.setKind(null);
        } else if (this.existential) {
            this.equivalent = null;
            this.kind = null;
            this.setKind(this.persistentKind);
        } else if (this.equivalent != null && this.persistentKind == NullnessKind.instance) {
            MonotypeConstructor mc = (MonotypeConstructor)this.equivalent();
            TypeConstructor tc = mc.getTC();
            NullnessKind.introduce(tc);
            MonotypeVar raw = (MonotypeVar)mc.getTP()[0];
            raw.reset();
            Engine.register(raw);
        }
    }

    public void allowUnknownTypeParameters() {
        MonotypeVar[] tps;
        if (this.equivalent instanceof MonotypeConstructor && (tps = (MonotypeVar[])((MonotypeConstructor)this.equivalent).getTP()) != null) {
            for (int i = 0; i < tps.length; ++i) {
                tps[i].allowUnknown = true;
                if (tps[i].equivalent == null) continue;
                tps[i].allowUnknownTypeParameters();
            }
        }
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public void setUnknown(boolean leq, boolean geq) throws Unsatisfiable {
        if (this.equivalent != null) {
            if (this.kind == NullnessKind.instance) {
                Monotype raw = ((MonotypeConstructor)this.equivalent()).getTP()[0];
                raw.setUnknown(leq, geq);
            } else if (!this.allowUnknown) {
                throw LowlevelUnsatisfiable.instance;
            }
        }
        this.equivalent = UnknownMonotype.instance;
        this.persistentKind = null;
        this.unknown = true;
    }

    public Monotype equivalent() {
        if (this.equivalent != null) {
            return this.equivalent;
        }
        return this;
    }

    public TypeConstructor head() {
        if (this.equivalent != null) {
            return this.equivalent.head();
        }
        return null;
    }

    public void setExistential() {
        this.existential = true;
    }

    public boolean isExistential() {
        return this.existential;
    }

    public String toString() {
        if (this.name == null) {
            this.name = MonotypeVar.newUniqueName();
        }
        return this.name;
    }

    private static String newUniqueName() {
        return "t" + uniqueNum++;
    }

    void tag(int variance) {
        if (this.equivalent != null) {
            this.equivalent.tag(variance);
        } else if (this.kind != TopMonotype.TopKind.instance) {
            Engine.tag(this, variance);
        }
    }

    Monotype canonify() {
        if (this.equivalent != null) {
            return this.equivalent.canonify();
        }
        if (this.isUnknown()) {
            return UnknownMonotype.instance;
        }
        if (this.kind == TopMonotype.TopKind.instance) {
            return TopMonotype.instance;
        }
        return (MonotypeVar)Engine.canonify(this);
    }
}

