/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.KawaConvert;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Undefined;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class Interpreter {
    public static Interpreter defaultInterpreter = null;
    public static final Boolean trueObject = Boolean.TRUE;
    public static final Boolean falseObject = Boolean.FALSE;
    public static final Undefined undefinedObject;
    public static final Object voidObject;
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    static String[][] languages;
    protected Environment environ;
    public static final int VALUE_NAMESPACE = 1;
    public static final int FUNCTION_NAMESPACE = 2;

    public static Interpreter getInterpreter() {
        return defaultInterpreter;
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static Interpreter getInstance(String name) {
        block2: for (String[] names : languages) {
            int nameCount;
            int j = nameCount = names.length - 1;
            while (--j >= 0) {
                Class<?> langClass;
                if (name != null && !names[j].equalsIgnoreCase(name)) continue;
                try {
                    langClass = Class.forName(names[nameCount]);
                }
                catch (ClassNotFoundException ex) {
                    continue block2;
                }
                return Interpreter.getInstance(name, langClass);
            }
        }
        return null;
    }

    protected Interpreter() {
        Convert.setInstance(KawaConvert.getInstance());
    }

    public static Interpreter getInstance(String langName, Class langClass) {
        try {
            Method method = langClass.getDeclaredMethod("getInstance", new Class[0]);
            return (Interpreter)method.invoke(null, Values.noArgs);
        }
        catch (Exception ex) {
            if (langName == null) {
                langName = langClass.getName();
            }
            throw new WrappedException("getInstance for '" + langName + "' failed", ex);
        }
    }

    public boolean isTrue(Object value) {
        return value != Boolean.FALSE;
    }

    public Object booleanObject(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object noValue() {
        return Values.empty;
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public Environment getEnvironment() {
        return this.environ;
    }

    public void setEnvironment(Environment environ) {
        this.environ = environ;
    }

    public void define(String sym, Object p) {
        this.environ.define(sym, p);
    }

    public Object lookup(String name) {
        return this.environ.get(name);
    }

    public abstract Object read(InPort var1) throws IOException, SyntaxException;

    public void print(Object obj, OutPort out) {
        this.print(obj, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object value, OutPort out, boolean readable) {
        if (value == Values.empty) {
            return;
        }
        FormatToConsumer saveFormat = out.objectFormat;
        try {
            out.objectFormat = this.getFormat(readable);
            if (value instanceof Values) {
                Object[] values = ((Values)value).getValues();
                for (int i = 0; i < values.length; ++i) {
                    out.println(values[i]);
                }
            } else {
                out.println(value);
            }
        }
        finally {
            out.objectFormat = saveFormat;
        }
    }

    public abstract FormatToConsumer getFormat(boolean var1);

    public Consumer getOutputConsumer(OutPort out) {
        out.objectFormat = this.getFormat(false);
        return out;
    }

    public Environment getNewEnvironment() {
        return new Environment(this.environ);
    }

    public abstract String getName();

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public abstract ModuleExp parse(Environment var1, Lexer var2) throws IOException, SyntaxException;

    public abstract ModuleExp parseFile(InPort var1, SourceMessages var2);

    public abstract Type getTypeFor(Class var1);

    public static Type string2Type(String name) {
        Type t;
        if (name.endsWith("[]")) {
            t = Interpreter.string2Type(name.substring(0, name.length() - 2));
            if (t == null) {
                return null;
            }
            t = ArrayType.make(t);
        } else if (Type.isValidJavaTypeName(name)) {
            t = Type.getType(name);
        } else {
            return null;
        }
        return t;
    }

    public Type getTypeFor(String name) {
        return Interpreter.string2Type(name);
    }

    public Type asType(Object spec) {
        if (!(spec instanceof Type)) {
            if (spec instanceof Class) {
                return this.getTypeFor((Class)spec);
            }
            if (spec instanceof String || spec instanceof Binding) {
                return this.getTypeFor(spec.toString());
            }
            if (spec instanceof CharSeq) {
                return ClassType.make(spec.toString());
            }
        }
        return (Type)spec;
    }

    public Type getTypeFor(Expression exp) {
        if (exp instanceof QuoteExp) {
            try {
                return this.asType(((QuoteExp)exp).getValue());
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (exp instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)exp;
            Declaration decl = rexp.getBinding();
            if (decl != null && !decl.getFlag(65536)) {
                return this.getTypeFor(decl.getValue());
            }
            String name = rexp.getName();
            Object val = Environment.getCurrent().get(name);
            if (val instanceof Type) {
                return (Type)val;
            }
            int len = name.length();
            if (len > 2 && name.charAt(0) == '<' && name.charAt(len - 1) == '>') {
                return this.getTypeFor(name.substring(1, len - 1));
            }
        } else if (exp instanceof ClassExp) {
            return ((ClassExp)exp).getType();
        }
        return null;
    }

    public int getNamespaceOf(Declaration decl) {
        return 1;
    }

    public void emitPushBoolean(boolean value, CodeAttr code) {
        code.emitGetStatic(value ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public void emitCoerceToBoolean(CodeAttr code) {
        this.emitPushBoolean(false, code);
        code.emitIfNEq();
        code.emitPushInt(1);
        code.emitElse();
        code.emitPushInt(0);
        code.emitFi();
    }

    public Object coerceFromObject(Class clas, Object obj) {
        return this.getTypeFor(clas).coerceFromObject(obj);
    }

    public Object coerceToObject(Class clas, Object obj) {
        return this.getTypeFor(clas).coerceToObject(obj);
    }

    public Object coerceToObject(int val) {
        return null;
    }

    public Procedure getPrompter() {
        Binding pr = Environment.getCurrentBinding("default-prompter");
        return pr == null ? null : pr.getProcedure();
    }

    static {
        new Undefined();
        undefinedObject = Undefined.getInstance();
        voidObject = Values.empty;
        languages = new String[][]{{"scheme", ".scm", ".sc", "kawa.standard.Scheme"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"xquery", ".xql", "gnu.xquery.lang.XQuery"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
    }
}

